/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;
import org.apache.commons.compress.utils.IOUtils;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.fife.ui.rtextarea.RUndoManager;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.EditorListener;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SketchTextAreaUI;

public class SketchTextArea
extends RSyntaxTextArea {
    private static final Logger LOG = Logger.getLogger(SketchTextArea.class.getName());
    private EditorListener editorListener;
    private PdeKeywords pdeKeywords;

    public SketchTextArea(PdeKeywords pdeKeywords) throws IOException {
        this.pdeKeywords = pdeKeywords;
        this.installFeatures();
    }

    public void setKeywords(PdeKeywords keywords) {
        this.pdeKeywords = keywords;
        this.setLinkGenerator(new DocLinkGenerator(this.pdeKeywords));
    }

    private void installFeatures() throws IOException {
        this.setTheme(PreferencesData.get((String)"editor.syntax_theme", (String)"default"));
        this.setLinkGenerator(new DocLinkGenerator(this.pdeKeywords));
        this.fixControlTab();
        this.setSyntaxEditingStyle("text/cpp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTheme(String name) throws IOException {
        FileInputStream defaultXmlInputStream = null;
        try {
            defaultXmlInputStream = new FileInputStream(new File(BaseNoGui.getContentFile((String)"lib"), "theme/syntax/" + name + ".xml"));
            org.fife.ui.rsyntaxtextarea.Theme theme = org.fife.ui.rsyntaxtextarea.Theme.load((InputStream)defaultXmlInputStream);
            theme.apply((RSyntaxTextArea)this);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(defaultXmlInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)defaultXmlInputStream);
        this.setEOLMarkersVisible(Theme.getBoolean("editor.eolmarkers"));
        this.setBackground(Theme.getColor("editor.bgcolor"));
        this.setHighlightCurrentLine(Theme.getBoolean("editor.linehighlight"));
        this.setCurrentLineHighlightColor(Theme.getColor("editor.linehighlight.color"));
        this.setCaretColor(Theme.getColor("editor.caret.color"));
        this.setSelectedTextColor(null);
        this.setUseSelectedTextColor(false);
        this.setSelectionColor(Theme.getColor("editor.selection.color"));
        this.setMatchedBracketBorderColor(Theme.getColor("editor.brackethighlight.color"));
        this.setHyperlinkForeground((Color)Theme.getStyledFont("url", this.getFont()).get("color"));
        this.setSyntaxTheme(16, "data_type");
        this.setSyntaxTheme(8, "function");
        this.setSyntaxTheme(6, "reserved_word");
        this.setSyntaxTheme(7, "reserved_word_2");
        this.setSyntaxTheme(17, "variable");
        this.setSyntaxTheme(23, "operator");
        this.setSyntaxTheme(3, "comment1");
        this.setSyntaxTheme(1, "comment1");
        this.setSyntaxTheme(4, "comment1");
        this.setSyntaxTheme(5, "comment1");
        this.setSyntaxTheme(2, "comment2");
        this.setSyntaxTheme(9, "literal_boolean");
        this.setSyntaxTheme(14, "literal_char");
        this.setSyntaxTheme(13, "literal_string_double_quote");
        this.setSyntaxTheme(24, "preprocessor");
        this.setColorForToken(20, "editor.fgcolor");
        this.setColorForToken(21, "editor.eolmarkers.color");
    }

    private void setColorForToken(int tokenType, String colorKeyFromTheme) {
        Style style = this.getSyntaxScheme().getStyle(tokenType);
        style.foreground = Theme.getColor(colorKeyFromTheme);
        this.getSyntaxScheme().setStyle(tokenType, style);
    }

    private void setSyntaxTheme(int tokenType, String id) {
        Style style = this.getSyntaxScheme().getStyle(tokenType);
        Map<String, Object> styledFont = Theme.getStyledFont(id, style.font);
        style.foreground = (Color)styledFont.get("color");
        style.font = (Font)styledFont.get("font");
        this.getSyntaxScheme().setStyle(tokenType, style);
    }

    private void fixControlTab() {
        this.removeCTRLTabFromFocusTraversal();
        this.removeCTRLSHIFTTabFromFocusTraversal();
    }

    private void removeCTRLSHIFTTabFromFocusTraversal() {
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke("ctrl shift TAB");
        HashSet backwardKeys = new HashSet(this.getFocusTraversalKeys(1));
        backwardKeys.remove(ctrlShiftTab);
    }

    private void removeCTRLTabFromFocusTraversal() {
        KeyStroke ctrlTab = KeyStroke.getKeyStroke("ctrl TAB");
        HashSet forwardKeys = new HashSet(this.getFocusTraversalKeys(0));
        forwardKeys.remove(ctrlTab);
        this.setFocusTraversalKeys(0, forwardKeys);
    }

    public boolean isSelectionActive() {
        return this.getSelectedText() != null;
    }

    public void processKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 400: {
                if (this.editorListener == null) break;
                this.editorListener.keyTyped(evt);
                break;
            }
            case 401: {
                if (this.editorListener == null) break;
                this.editorListener.keyPressed(evt);
                break;
            }
        }
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void switchDocument(Document document, UndoManager newUndo) {
        this.setUndoManager(null);
        super.setDocument(document);
        this.setUndoManager((RUndoManager)newUndo);
    }

    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new SketchTextAreaMouseListener((RTextArea)this);
    }

    public void getTextLine(int line, Segment segment) {
        try {
            int offset = this.getLineStartOffset(line);
            int end = this.getLineEndOffset(line);
            this.getDocument().getText(offset, end - offset, segment);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setEditorListener(EditorListener editorListener) {
        this.editorListener = editorListener;
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new SketchTextAreaUI((JComponent)((Object)this));
    }

    private class SketchTextAreaMouseListener
    extends RTextArea.RTextAreaMutableCaretEvent {
        private Insets insets;
        private boolean isScanningForLinks;
        private int hoveredOverLinkOffset;

        SketchTextAreaMouseListener(RTextArea textArea) {
            super((RTextArea)SketchTextArea.this, textArea);
            this.hoveredOverLinkOffset = -1;
            this.insets = new Insets(0, 0, 0, 0);
        }

        private void fireHyperlinkUpdate(HyperlinkEvent e) {
            Object[] listeners = SketchTextArea.this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != HyperlinkListener.class) continue;
                ((HyperlinkListener)listeners[i + 1]).hyperlinkUpdate(e);
            }
        }

        private HyperlinkEvent createHyperlinkEvent(MouseEvent e) {
            HyperlinkEvent he = null;
            Token t = SketchTextArea.this.viewToToken(e.getPoint());
            if (t != null) {
                t = new TokenImpl(t);
            }
            if (t != null && t.isHyperlink()) {
                URL url = null;
                String desc = null;
                try {
                    String temp = t.getLexeme();
                    if (temp.startsWith("www.")) {
                        temp = "http://" + temp;
                    }
                    url = new URL(temp);
                }
                catch (MalformedURLException mue) {
                    desc = mue.getMessage();
                }
                he = new HyperlinkEvent((Object)SketchTextArea.this, HyperlinkEvent.EventType.ACTIVATED, url, desc);
            }
            return he;
        }

        public void mouseClicked(MouseEvent e) {
            HyperlinkEvent he;
            if (SketchTextArea.this.getHyperlinksEnabled() && (he = this.createHyperlinkEvent(e)) != null) {
                this.fireHyperlinkUpdate(he);
            }
        }

        public void mouseMoved(MouseEvent e) {
            Cursor c2;
            super.mouseMoved(e);
            if (!SketchTextArea.this.getHyperlinksEnabled()) {
                return;
            }
            this.insets = SketchTextArea.this.getInsets(this.insets);
            if (this.insets != null) {
                int x = e.getX();
                int y = e.getY();
                if (x <= this.insets.left || y < this.insets.top) {
                    if (this.isScanningForLinks) {
                        this.stopScanningForLinks();
                    }
                    return;
                }
            }
            this.isScanningForLinks = true;
            Token t = SketchTextArea.this.viewToToken(e.getPoint());
            if (t != null) {
                t = new TokenImpl(t);
            }
            if (t != null && t.isHyperlink()) {
                if (this.hoveredOverLinkOffset == -1 || this.hoveredOverLinkOffset != t.getOffset()) {
                    this.hoveredOverLinkOffset = t.getOffset();
                    SketchTextArea.this.repaint();
                }
                c2 = Cursor.getPredefinedCursor(12);
            } else {
                c2 = Cursor.getPredefinedCursor(2);
                this.hoveredOverLinkOffset = -1;
            }
            if (SketchTextArea.this.getCursor() != c2) {
                SketchTextArea.this.setCursor(c2);
                SketchTextArea.this.repaint();
            }
        }

        private void stopScanningForLinks() {
            if (this.isScanningForLinks) {
                Cursor c = SketchTextArea.this.getCursor();
                this.isScanningForLinks = false;
                if (c.getType() == 12) {
                    SketchTextArea.this.setCursor(Cursor.getPredefinedCursor(2));
                    SketchTextArea.this.repaint();
                }
            }
        }
    }

    private static class DocLinkGenerator
    implements LinkGenerator {
        private final PdeKeywords pdeKeywords;

        public DocLinkGenerator(PdeKeywords pdeKeywords) {
            this.pdeKeywords = pdeKeywords;
        }

        public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, final int offs) {
            Token token = textArea.modelToToken(offs);
            if (token == null) {
                return null;
            }
            final String reference = this.pdeKeywords.getReference(token.getLexeme());
            if (reference != null || token.getType() == 16 || token.getType() == 17 || token.getType() == 8) {
                return new LinkGeneratorResult(){

                    public int getSourceOffset() {
                        return offs;
                    }

                    public HyperlinkEvent execute() {
                        LOG.fine("Open Reference: " + reference);
                        Base.showReference("Reference/" + reference);
                        return null;
                    }
                };
            }
            return null;
        }
    }
}

