/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import processing.app.AbstractMonitor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.Theme;
import processing.app.helpers.CircularBuffer;
import processing.app.helpers.Ticks;
import processing.app.legacy.PApplet;

public class SerialPlotter
extends AbstractMonitor {
    private final StringBuffer messageBuffer;
    private JComboBox<String> serialRates;
    private Serial serial;
    private int serialRate = PreferencesData.getInteger((String)"serial.debug_rate");
    private ArrayList<Graph> graphs;
    private static final int BUFFER_CAPACITY = 500;

    public SerialPlotter(BoardPort port) {
        super(port);
        this.serialRates.setSelectedItem(this.serialRate + " " + I18n.tr((String)"baud"));
        this.onSerialRateChange(event -> {
            String wholeString = (String)this.serialRates.getSelectedItem();
            String rateString = wholeString.substring(0, wholeString.indexOf(32));
            this.serialRate = Integer.parseInt(rateString);
            PreferencesData.set((String)"serial.debug_rate", (String)rateString);
            try {
                this.close();
                Thread.sleep(100L);
                this.open();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.messageBuffer = new StringBuffer();
        this.graphs = new ArrayList();
    }

    @Override
    protected void onCreateWindow(Container mainPane) {
        mainPane.setLayout(new BorderLayout());
        GraphPanel graphPanel = new GraphPanel();
        mainPane.add((Component)graphPanel, "Center");
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.serialRates = new JComboBox();
        for (String serialRateString : this.serialRateStrings) {
            this.serialRates.addItem(serialRateString + " " + I18n.tr((String)"baud"));
        }
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        pane.add(Box.createRigidArea(new Dimension(8, 0)));
        pane.add(this.serialRates);
        mainPane.add((Component)pane, "South");
    }

    @Override
    protected void onEnableWindow(boolean enable) {
        this.serialRates.setEnabled(enable);
    }

    private void onSerialRateChange(ActionListener listener) {
        this.serialRates.addActionListener(listener);
    }

    @Override
    public void message(String s) {
        int linebreak;
        this.messageBuffer.append(s);
        while ((linebreak = this.messageBuffer.indexOf("\n")) != -1) {
            String line = this.messageBuffer.substring(0, linebreak);
            this.messageBuffer.delete(0, linebreak + 1);
            line = line.trim();
            String[] parts = line.split("[, \t]+");
            if (parts.length == 0) continue;
            int validParts = 0;
            for (int i = 0; i < parts.length; ++i) {
                try {
                    double value = Double.valueOf(parts[i]);
                    if (i >= this.graphs.size()) {
                        this.graphs.add(new Graph(validParts));
                    }
                    this.graphs.get((int)validParts).buffer.add(value);
                    ++validParts;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.getBoardPort().getAddress(), this.serialRate){

            protected void message(char[] buff, int n) {
                SerialPlotter.this.addToUpdateBuffer(buff, n);
            }
        };
    }

    @Override
    public void close() throws Exception {
        if (this.serial != null) {
            super.close();
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            PreferencesData.set((String)"last.serial.location", (String)locationStr);
            this.serial.dispose();
            this.serial = null;
        }
    }

    private class GraphPanel
    extends JPanel {
        private double minY;
        private double maxY;
        private double rangeY;
        private Rectangle bounds;
        private int xOffset = 20;
        private final Font font = Theme.getFont("console.font");
        private final Color bgColor = Theme.getColor("plotting.bgcolor");

        private Ticks computeBounds() {
            this.minY = Double.POSITIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            for (Graph g : SerialPlotter.this.graphs) {
                double bMin = g.buffer.min() / 2.0;
                double bMax = g.buffer.max() * 2.0;
                this.minY = bMin < this.minY ? bMin : this.minY;
                this.maxY = bMax > this.maxY ? bMax : this.maxY;
            }
            Ticks ticks = new Ticks(this.minY, this.maxY, 3);
            this.minY = Math.min(this.minY, ticks.getTick(0));
            this.maxY = Math.max(this.maxY, ticks.getTick(ticks.getTickCount() - 1));
            this.rangeY = this.maxY - this.minY;
            this.minY -= 0.05 * this.rangeY;
            this.maxY += 0.05 * this.rangeY;
            this.rangeY = this.maxY - this.minY;
            return ticks;
        }

        @Override
        public void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(this.font);
            super.paintComponent(g);
            this.bounds = g.getClipBounds();
            this.setBackground(this.bgColor);
            if (SerialPlotter.this.graphs.isEmpty()) {
                return;
            }
            Ticks ticks = this.computeBounds();
            g.setStroke(new BasicStroke(1.0f));
            FontMetrics fm = g.getFontMetrics();
            for (int i = 0; i < ticks.getTickCount(); ++i) {
                double tick = ticks.getTick(i);
                Rectangle2D fRect = fm.getStringBounds(String.valueOf(tick), g);
                this.xOffset = Math.max(this.xOffset, (int)fRect.getWidth() + 15);
                g.drawLine(this.xOffset - 5, (int)this.transformY(tick), this.xOffset + 2, (int)this.transformY(tick));
                g.drawString(String.valueOf(tick), (float)(this.xOffset - (int)fRect.getWidth() - 10), this.transformY(tick) - (float)fRect.getHeight() * 0.5f + (float)fm.getAscent());
            }
            g.drawLine(this.bounds.x + this.xOffset, this.bounds.y + 5, this.bounds.x + this.xOffset, this.bounds.y + this.bounds.height - 10);
            g.setTransform(AffineTransform.getTranslateInstance(this.xOffset, 0.0));
            float xstep = (float)(this.bounds.width - this.xOffset) / 500.0f;
            int legendLength = SerialPlotter.this.graphs.size() * 10 + (SerialPlotter.this.graphs.size() - 1) * 3;
            for (int i = 0; i < SerialPlotter.this.graphs.size(); ++i) {
                ((Graph)SerialPlotter.this.graphs.get(i)).paint(g, xstep, this.minY, this.maxY, this.rangeY, this.bounds.height);
                if (SerialPlotter.this.graphs.size() <= 1) continue;
                g.fillRect(this.bounds.width - (this.xOffset + legendLength + 10) + i * 13, 10, 10, 10);
            }
        }

        private float transformY(double rawY) {
            return (float)(5.0 + (double)(this.bounds.height - 10) * (1.0 - (rawY - this.minY) / this.rangeY));
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(200, 100);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(500, 250);
        }
    }

    private static class Graph {
        public CircularBuffer buffer = new CircularBuffer(500);
        private Color color;

        public Graph(int id) {
            this.color = Theme.getColorCycleColor("plotting.graphcolor", id);
        }

        public void paint(Graphics2D g, float xstep, double minY, double maxY, double rangeY, double height) {
            g.setColor(this.color);
            g.setStroke(new BasicStroke(1.0f));
            for (int i = 0; i < this.buffer.size() - 1; ++i) {
                g.drawLine((int)((float)i * xstep), (int)this.transformY(this.buffer.get(i), minY, rangeY, height), (int)((float)(i + 1) * xstep), (int)this.transformY(this.buffer.get(i + 1), minY, rangeY, height));
            }
        }

        private float transformY(double rawY, double minY, double rangeY, double height) {
            return (float)(5.0 + (height - 10.0) * (1.0 - (rawY - minY) / rangeY));
        }
    }
}

