/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.ConsoleOutputStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.PreferencesData;
import processing.app.Theme;

public class EditorConsole
extends JScrollPane {
    private static ConsoleOutputStream out;
    private static ConsoleOutputStream err;
    private final DefaultStyledDocument document = new DefaultStyledDocument();
    private final JTextPane consoleTextPane = new JTextPane(this.document);

    private static synchronized void init(SimpleAttributeSet outStyle, PrintStream outStream, SimpleAttributeSet errStyle, PrintStream errStream) {
        if (out != null) {
            return;
        }
        out = new ConsoleOutputStream(outStyle, outStream);
        System.setOut(new PrintStream(out, true));
        err = new ConsoleOutputStream(errStyle, errStream);
        System.setErr(new PrintStream(err, true));
    }

    public static void setCurrentEditorConsole(EditorConsole console) {
        out.setCurrentEditorConsole(console);
        err.setCurrentEditorConsole(console);
    }

    public EditorConsole() {
        this.consoleTextPane.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.consoleTextPane.getCaret();
        caret.setUpdatePolicy(1);
        Color backgroundColour = Theme.getColor("console.color");
        this.consoleTextPane.setBackground(backgroundColour);
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        Font actualFont = new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize());
        SimpleAttributeSet stdOutStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(stdOutStyle, Theme.getColor("console.output.color"));
        StyleConstants.setBackground(stdOutStyle, backgroundColour);
        StyleConstants.setFontSize(stdOutStyle, actualFont.getSize());
        StyleConstants.setFontFamily(stdOutStyle, actualFont.getFamily());
        StyleConstants.setBold(stdOutStyle, actualFont.isBold());
        StyleConstants.setItalic(stdOutStyle, actualFont.isItalic());
        this.consoleTextPane.setParagraphAttributes(stdOutStyle, true);
        SimpleAttributeSet stdErrStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(stdErrStyle, Theme.getColor("console.error.color"));
        StyleConstants.setBackground(stdErrStyle, backgroundColour);
        StyleConstants.setFontSize(stdErrStyle, actualFont.getSize());
        StyleConstants.setFontFamily(stdErrStyle, actualFont.getFamily());
        StyleConstants.setBold(stdErrStyle, actualFont.isBold());
        StyleConstants.setItalic(stdErrStyle, actualFont.isItalic());
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this.consoleTextPane);
        this.setViewportView(noWrapPanel);
        this.getVerticalScrollBar().setUnitIncrement(7);
        FontMetrics metrics = this.getFontMetrics(actualFont);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = PreferencesData.getInteger((String)"console.lines");
        int sizeFudge = 6;
        this.setPreferredSize(new Dimension(1024, height * lines + sizeFudge));
        this.setMinimumSize(new Dimension(1024, height * 5 + sizeFudge));
        EditorConsole.init(stdOutStyle, System.out, stdErrStyle, System.err);
    }

    public void clear() {
        try {
            this.document.remove(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void scrollDown() {
        this.getHorizontalScrollBar().setValue(0);
        this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getMaximum());
    }

    public boolean isEmpty() {
        return this.document.getLength() == 0;
    }

    public void insertString(String line, SimpleAttributeSet attributes) throws BadLocationException {
        line = line.replace("\r\n", "\n").replace("\r", "\n");
        int offset = this.document.getLength();
        this.document.insertString(offset, line, attributes);
    }

    public String getText() {
        return this.consoleTextPane.getText().trim();
    }
}

