/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import processing.app.Base;
import processing.app.BaseNoGui;

public class NotificationPopup
extends JDialog {
    private final ComponentAdapter parentMovedListener;
    private JButton closeButton;
    private JLabel icon;
    private JEditorPane text;

    public NotificationPopup(final Frame parent, HyperlinkListener hyperlinkListener, String message) {
        super(parent, false);
        this.initComponents();
        this.updateLocation(parent);
        this.parentMovedListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                NotificationPopup.this.updateLocation(parent);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                NotificationPopup.this.updateLocation(parent);
            }
        };
        parent.addComponentListener(this.parentMovedListener);
        this.text.setText("<html><body style=\"font-family:sans-serif;font-size:12pt\">" + message + "</body></html>");
        this.text.addHyperlinkListener(hyperlinkListener);
        this.text.addHyperlinkListener(e -> {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            this.close();
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                parent.removeComponentListener(NotificationPopup.this.parentMovedListener);
            }
        });
        Base.registerWindowCloseKeys(this.getRootPane(), e -> this.close());
        MouseAdapter closeOnClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NotificationPopup.this.close();
            }
        };
        this.addMouseListener(closeOnClick);
        this.text.addMouseListener(closeOnClick);
        this.icon.addMouseListener(closeOnClick);
    }

    private void updateLocation(Frame parent) {
        Point parentLocation = parent.getLocation();
        int parentX = Double.valueOf(parentLocation.getX()).intValue();
        int parentY = Double.valueOf(parentLocation.getY()).intValue();
        this.setLocation(parentX, parentY + parent.getHeight() - this.getHeight());
    }

    public void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void initComponents() {
        this.icon = new JLabel();
        this.text = new JEditorPane();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(350, 70));
        this.setResizable(false);
        this.setSize(new Dimension(350, 70));
        this.getContentPane().setLayout(null);
        this.icon.setIcon(new ImageIcon(Paths.get(BaseNoGui.getContentFile((String)"lib").getAbsolutePath(), "arduino_small.png").toFile().getAbsolutePath()));
        this.getContentPane().add(this.icon);
        this.icon.setBounds(10, 10, 50, 50);
        this.text.setEditable(false);
        this.text.setBorder(new LineBorder(new Color(0, 0, 0), 0, true));
        this.text.setContentType("text/html");
        this.text.setOpaque(false);
        this.getContentPane().add(this.text);
        this.text.setBounds(70, 10, 270, 50);
        this.closeButton.setIcon(new ImageIcon(Paths.get(BaseNoGui.getContentFile((String)"lib").getAbsolutePath(), "theme", "close.png").toFile().getAbsolutePath()));
        this.closeButton.setBorder(null);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setHideActionText(true);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPopup.this.closeButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.closeButton);
        this.closeButton.setBounds(328, 0, 22, 22);
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationPopup dialog = new NotificationPopup((Frame)new JFrame(), System.out::println, "<a href='arduinoide://boardsmanager'>test</a> test test test test test test test test\n test test test test test test test test test test test");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

