/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import processing.app.BaseNoGui;

public class ContributionIndexTableModel
extends FilteredAbstractTableModel<ContributedPlatform> {
    public static final int DESCRIPTION_COL = 0;
    private final List<ContributedPlatformReleases> contributions = new ArrayList<ContributedPlatformReleases>();
    private final String[] columnNames = new String[]{"Description"};
    private final Class<?>[] columnTypes = new Class[]{ContributedPlatform.class};

    @Override
    public void updateIndexFilter(String[] filters, Stream<Predicate<ContributedPlatform>> additionalFilters) {
        this.contributions.clear();
        Predicate<ContributedPlatform> filter = additionalFilters.reduce(Predicate::and).get();
        for (ContributedPackage pack : BaseNoGui.indexer.getPackages()) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                String compoundTargetSearchText = platform.getName() + "\n" + platform.getBoards().stream().map(ContributedBoard::getName).collect(Collectors.joining(" "));
                if (!filter.test(platform) || !this.stringContainsAll(compoundTargetSearchText, filters)) continue;
                this.addContribution(platform);
            }
        }
        this.fireTableDataChanged();
    }

    private boolean stringContainsAll(String string, String[] set) {
        if (set == null) {
            return true;
        }
        for (String s : set) {
            if (string.toLowerCase().contains(s.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void addContribution(ContributedPlatform platform) {
        for (ContributedPlatformReleases contribution : this.contributions) {
            if (!contribution.shouldContain(platform)) continue;
            contribution.add(platform);
            return;
        }
        this.contributions.add(new ContributedPlatformReleases(platform));
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.contributions.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int colum) {
        return this.columnTypes[colum];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.contributions.size()) {
            return null;
        }
        ContributedPlatformReleases contribution = this.contributions.get(row);
        if (col == 0) {
            return contribution;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public ContributedPlatformReleases getReleases(int row) {
        return this.contributions.get(row);
    }

    public ContributedPlatform getSelectedRelease(int row) {
        return this.contributions.get(row).getSelected();
    }

    public void update() {
        this.fireTableDataChanged();
    }

    public static class ContributedPlatformReleases {
        public final ContributedPackage packager;
        public final String arch;
        public final List<ContributedPlatform> releases;
        public final List<String> versions;
        public ContributedPlatform selected = null;

        public ContributedPlatformReleases(ContributedPlatform platform) {
            this.packager = platform.getParentPackage();
            this.arch = platform.getArchitecture();
            this.releases = new LinkedList<ContributedPlatform>();
            this.versions = new LinkedList<String>();
            this.add(platform);
        }

        public boolean shouldContain(ContributedPlatform platform) {
            if (platform.getParentPackage() != this.packager) {
                return false;
            }
            return platform.getArchitecture().equals(this.arch);
        }

        public void add(ContributedPlatform platform) {
            this.releases.add(platform);
            String version = platform.getParsedVersion();
            if (version != null) {
                this.versions.add(version);
            }
            this.selected = this.getLatest();
        }

        public ContributedPlatform getInstalled() {
            List installedReleases = this.releases.stream().filter(new InstalledPredicate()).collect(Collectors.toList());
            Collections.sort(installedReleases, new DownloadableContributionBuiltInAtTheBottomComparator());
            if (installedReleases.isEmpty()) {
                return null;
            }
            return (ContributedPlatform)installedReleases.get(0);
        }

        public ContributedPlatform getLatest() {
            return FilteredAbstractTableModel.getLatestOf(this.releases);
        }

        public ContributedPlatform getSelected() {
            return this.selected;
        }

        public void select(ContributedPlatform value) {
            for (ContributedPlatform plat : this.releases) {
                if (plat != value) continue;
                this.selected = plat;
                return;
            }
        }
    }
}

