/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedHelp;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ui.ContributionIndexTableModel;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.contributions.ui.listeners.DelegatingKeyListener;
import cc.arduino.utils.ReverseComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.I18n;

public class ContributedPlatformTableCell
extends InstallerTableCell {
    private final JPanel panel;
    private final JButton installButton;
    private final JButton removeButton;
    private final Component removeButtonPlaceholder;
    private final Component installButtonPlaceholder;
    private JComboBox downgradeChooser;
    private final JComboBox versionToInstallChooser;
    private final JButton downgradeButton;
    private final JPanel buttonsPanel;
    private final JPanel inactiveButtonsPanel;
    private final JLabel statusLabel;
    private ContributionIndexTableModel.ContributedPlatformReleases editorValue;
    private JTable parentTable;
    private final Timer enabler = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ContributedPlatformTableCell.this.enable(true);
            ContributedPlatformTableCell.this.enabler.stop();
        }
    });

    public ContributedPlatformTableCell() {
        this.installButton = new JButton(I18n.tr((String)"Install"));
        this.installButton.addActionListener(e -> this.onInstall(this.editorValue.getSelected(), this.editorValue.getInstalled()));
        int width = this.installButton.getPreferredSize().width;
        this.installButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.removeButton = new JButton(I18n.tr((String)"Remove"));
        this.removeButton.addActionListener(e -> this.onRemove(this.editorValue.getInstalled()));
        width = this.removeButton.getPreferredSize().width;
        this.removeButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.downgradeButton = new JButton(I18n.tr((String)"Install"));
        this.downgradeButton.addActionListener(e -> {
            ContributedPlatform selected = (ContributedPlatform)this.downgradeChooser.getSelectedItem();
            this.onInstall(selected, this.editorValue.getInstalled());
        });
        this.downgradeChooser = new JComboBox();
        this.downgradeChooser.addItem("-");
        this.downgradeChooser.setMaximumSize(this.downgradeChooser.getPreferredSize());
        this.downgradeChooser.addItemListener(e -> {
            Object selectVersionItem = this.downgradeChooser.getItemAt(0);
            boolean disableDowngrade = e.getItem() == selectVersionItem;
            this.downgradeButton.setEnabled(!disableDowngrade);
        });
        this.versionToInstallChooser = new JComboBox();
        this.versionToInstallChooser.addItem("-");
        this.versionToInstallChooser.setMaximumSize(this.versionToInstallChooser.getPreferredSize());
        this.versionToInstallChooser.addItemListener(e -> this.editorValue.select((ContributedPlatform)this.versionToInstallChooser.getSelectedItem()));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.makeNewDescription(this.panel);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.add(Box.createHorizontalStrut(7));
        this.buttonsPanel.add(this.downgradeChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.downgradeButton);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.versionToInstallChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.installButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.removeButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(Box.createHorizontalStrut(15));
        this.panel.add(this.buttonsPanel);
        this.inactiveButtonsPanel = new JPanel();
        this.inactiveButtonsPanel.setLayout(new BoxLayout(this.inactiveButtonsPanel, 0));
        this.inactiveButtonsPanel.setOpaque(false);
        int height = this.installButton.getMinimumSize().height;
        this.inactiveButtonsPanel.add(Box.createVerticalStrut(height));
        this.inactiveButtonsPanel.add(Box.createGlue());
        this.statusLabel = new JLabel(" ");
        this.inactiveButtonsPanel.add(this.statusLabel);
        this.inactiveButtonsPanel.add(Box.createHorizontalStrut(15));
        this.panel.add(this.inactiveButtonsPanel);
        this.panel.add(Box.createVerticalStrut(15));
    }

    private JTextPane makeNewDescription(JPanel panel) {
        if (panel.getComponentCount() > 0) {
            panel.remove(0);
        }
        JTextPane description = new JTextPane();
        description.setInheritsPopupMenu(true);
        Insets margin = description.getMargin();
        margin.bottom = 0;
        description.setMargin(margin);
        description.setContentType("text/html");
        Document doc = description.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            stylesheet.addRule("body { margin: 0; padding: 0;font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;font-size: 100%;font-size: 0.95em; }");
        }
        description.setOpaque(false);
        description.setBorder(new EmptyBorder(4, 7, 7, 7));
        description.setHighlighter(null);
        description.setEditable(false);
        description.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Base.openURL(e.getDescription());
            }
        });
        description.addKeyListener(new DelegatingKeyListener(this.parentTable));
        panel.add((Component)description, 0);
        return description;
    }

    protected void onRemove(ContributedPlatform contributedPlatform) {
    }

    protected void onInstall(ContributedPlatform contributedPlatform, ContributedPlatform installed) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.parentTable = table;
        this.setEnabled(false);
        Component component = this.getUpdatedCellComponent(value, isSelected, row, false);
        if (row % 2 == 0) {
            component.setBackground(new Color(236, 241, 241));
        } else {
            component.setBackground(new Color(255, 255, 255));
        }
        int height = new Double(component.getPreferredSize().getHeight()).intValue();
        if (table.getRowHeight(row) < height) {
            table.setRowHeight(row, height);
        }
        return component;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.parentTable = table;
        this.editorValue = (ContributionIndexTableModel.ContributedPlatformReleases)value;
        this.setEnabled(true);
        ContributedPlatform installed = this.editorValue.getInstalled();
        LinkedList<ContributedPlatform> releases = new LinkedList<ContributedPlatform>(this.editorValue.releases);
        List<ContributedPlatform> uninstalledReleases = releases.stream().filter(new InstalledPredicate().negate()).collect(Collectors.toList());
        List installedBuiltIn = releases.stream().filter(new InstalledPredicate()).filter(new BuiltInPredicate()).collect(Collectors.toList());
        if (installed != null && !installedBuiltIn.contains(installed)) {
            uninstalledReleases.addAll(installedBuiltIn);
        }
        Collections.sort(uninstalledReleases, new ReverseComparator((Comparator)new DownloadableContributionVersionComparator()));
        this.downgradeChooser.removeAllItems();
        this.downgradeChooser.addItem(I18n.tr((String)"Select version"));
        LinkedList uninstalledPreviousReleases = new LinkedList();
        LinkedList uninstalledNewerReleases = new LinkedList();
        VersionComparator versionComparator = new VersionComparator();
        uninstalledReleases.stream().forEach(input -> {
            if (installed == null || versionComparator.greaterThan(installed.getParsedVersion(), input.getParsedVersion())) {
                uninstalledPreviousReleases.add(input);
            } else {
                uninstalledNewerReleases.add(input);
            }
        });
        uninstalledNewerReleases.forEach(this.downgradeChooser::addItem);
        uninstalledPreviousReleases.forEach(this.downgradeChooser::addItem);
        this.downgradeChooser.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.downgradeButton.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.versionToInstallChooser.removeAllItems();
        uninstalledReleases.forEach(this.versionToInstallChooser::addItem);
        this.versionToInstallChooser.setVisible(installed == null && uninstalledReleases.size() > 1);
        Component component = this.getUpdatedCellComponent(value, true, row, !installedBuiltIn.isEmpty());
        component.setBackground(new Color(218, 227, 227));
        return component;
    }

    private Component getUpdatedCellComponent(Object value, boolean isSelected, int row, boolean hasBuiltInRelease) {
        String url;
        String author;
        boolean upgradable;
        boolean removable;
        boolean installable;
        ContributionIndexTableModel.ContributedPlatformReleases releases = (ContributionIndexTableModel.ContributedPlatformReleases)value;
        JTextPane description = this.makeNewDescription(this.panel);
        if (releases == null) {
            return this.panel;
        }
        ContributedPlatform selected = releases.getSelected();
        ContributedPlatform installed = releases.getInstalled();
        if (installed == null) {
            installable = true;
            removable = false;
            upgradable = false;
        } else {
            installable = false;
            removable = !installed.isReadOnly() && !hasBuiltInRelease;
            boolean bl = upgradable = new DownloadableContributionVersionComparator().compare((DownloadableContribution)selected, (DownloadableContribution)installed) > 0;
        }
        if (installable) {
            this.installButton.setText(I18n.tr((String)"Install"));
        }
        if (upgradable) {
            this.installButton.setText(I18n.tr((String)"Update"));
        }
        this.installButton.setVisible(installable || upgradable);
        this.installButtonPlaceholder.setVisible(!installable && !upgradable);
        this.removeButton.setVisible(removable);
        this.removeButtonPlaceholder.setVisible(!removable);
        String desc = "<html><body>";
        desc = desc + "<b>" + selected.getName() + "</b>";
        if (installed != null && installed.isReadOnly()) {
            desc = desc + " Built-In ";
        }
        if ((author = selected.getParentPackage().getMaintainer()) != null && !author.isEmpty()) {
            desc = desc + " " + I18n.format((String)"by <b>{0}</b>", (Object[])new Object[]{author});
        }
        if (installed != null) {
            desc = desc + " " + I18n.format((String)I18n.tr((String)"version <b>{0}</b>"), (Object[])new Object[]{installed.getParsedVersion()}) + " <strong><font color=\"#00979D\">INSTALLED</font></strong>";
        }
        desc = desc + "<br />";
        desc = desc + I18n.tr((String)"Boards included in this package:") + "<br />";
        for (ContributedBoard board : selected.getBoards()) {
            desc = desc + board.getName() + ", ";
        }
        if (desc.lastIndexOf(44) != -1) {
            desc = desc.substring(0, desc.lastIndexOf(44)) + ".<br />";
        }
        ContributedHelp help = null;
        if (selected.getHelp() != null) {
            help = selected.getHelp();
        } else if (selected.getParentPackage().getHelp() != null) {
            help = selected.getParentPackage().getHelp();
        }
        if (help != null && (url = help.getOnline()) != null && !url.isEmpty()) {
            desc = desc + " " + I18n.format((String)"<a href=\"{0}\">Online help</a><br/>", (Object[])new Object[]{url});
        }
        if ((url = selected.getParentPackage().getWebsiteURL()) != null && !url.isEmpty()) {
            desc = desc + " " + I18n.format((String)"<a href=\"{0}\">More info</a>", (Object[])new Object[]{url});
        }
        desc = desc + "</body></html>";
        description.setText(desc);
        description.setBackground(Color.WHITE);
        int width = this.parentTable.getBounds().width;
        this.setJTextPaneDimensionToFitContainedText(description, width);
        if (isSelected) {
            this.panel.setBackground(this.parentTable.getSelectionBackground());
            this.panel.setForeground(this.parentTable.getSelectionForeground());
        } else {
            this.panel.setBackground(this.parentTable.getBackground());
            this.panel.setForeground(this.parentTable.getForeground());
        }
        return this.panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enable(false);
        if (enabled) {
            this.enabler.start();
        } else {
            this.enabler.stop();
        }
        this.buttonsPanel.setVisible(enabled);
        this.inactiveButtonsPanel.setVisible(!enabled);
    }

    public void enable(boolean enabled) {
        this.installButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    @Override
    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public void invalidate() {
        this.panel.invalidate();
    }
}

