/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.filters.OnlyUpstreamReleasePredicate;
import cc.arduino.contributions.libraries.ui.ContributedLibraryReleases;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.contributions.ui.listeners.DelegatingKeyListener;
import cc.arduino.utils.ReverseComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.I18n;

public class ContributedLibraryTableCell
extends InstallerTableCell {
    private final JPanel panel;
    private final JButton installButton;
    private final Component installButtonPlaceholder;
    private JComboBox downgradeChooser;
    private final JComboBox versionToInstallChooser;
    private final JButton downgradeButton;
    private final JPanel buttonsPanel;
    private final JPanel inactiveButtonsPanel;
    private final JLabel statusLabel;
    private ContributedLibraryReleases editorValue;
    private JTable parentTable;
    private final Timer enabler = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ContributedLibraryTableCell.this.enable(true);
            ContributedLibraryTableCell.this.enabler.stop();
        }
    });

    public ContributedLibraryTableCell() {
        this.installButton = new JButton(I18n.tr((String)"Install"));
        this.installButton.addActionListener(e -> this.onInstall(this.editorValue.getSelected(), this.editorValue.getInstalled()));
        int width = this.installButton.getPreferredSize().width;
        this.installButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.downgradeButton = new JButton(I18n.tr((String)"Install"));
        this.downgradeButton.addActionListener(e -> {
            ContributedLibrary selected = (ContributedLibrary)this.downgradeChooser.getSelectedItem();
            this.onInstall(selected, this.editorValue.getInstalled());
        });
        this.downgradeChooser = new JComboBox();
        this.downgradeChooser.addItem("-");
        this.downgradeChooser.setMaximumSize(this.downgradeChooser.getPreferredSize());
        this.downgradeChooser.addItemListener(e -> {
            Object selectVersionItem = this.downgradeChooser.getItemAt(0);
            boolean disableDowngrade = e.getItem() == selectVersionItem;
            this.downgradeButton.setEnabled(!disableDowngrade);
        });
        this.versionToInstallChooser = new JComboBox();
        this.versionToInstallChooser.addItem("-");
        this.versionToInstallChooser.setMaximumSize(this.versionToInstallChooser.getPreferredSize());
        this.versionToInstallChooser.addItemListener(e -> this.editorValue.select((ContributedLibrary)this.versionToInstallChooser.getSelectedItem()));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.makeNewDescription(this.panel);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.add(Box.createHorizontalStrut(7));
        this.buttonsPanel.add(this.downgradeChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.downgradeButton);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.versionToInstallChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.installButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(Box.createHorizontalStrut(15));
        this.panel.add(this.buttonsPanel);
        this.inactiveButtonsPanel = new JPanel();
        this.inactiveButtonsPanel.setLayout(new BoxLayout(this.inactiveButtonsPanel, 0));
        this.inactiveButtonsPanel.setOpaque(false);
        int height = this.installButton.getMinimumSize().height;
        this.inactiveButtonsPanel.add(Box.createVerticalStrut(height));
        this.inactiveButtonsPanel.add(Box.createGlue());
        this.statusLabel = new JLabel(" ");
        this.inactiveButtonsPanel.add(this.statusLabel);
        this.inactiveButtonsPanel.add(Box.createHorizontalStrut(15));
        this.panel.add(this.inactiveButtonsPanel);
        this.panel.add(Box.createVerticalStrut(15));
    }

    private JTextPane makeNewDescription(JPanel panel) {
        if (panel.getComponentCount() > 0) {
            panel.remove(0);
        }
        JTextPane description = new JTextPane();
        description.setInheritsPopupMenu(true);
        Insets margin = description.getMargin();
        margin.bottom = 0;
        description.setMargin(margin);
        description.setContentType("text/html");
        Document doc = description.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            stylesheet.addRule("body { margin: 0; padding: 0;font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;font-size: 100%;font-size: 0.95em; }");
        }
        description.setOpaque(false);
        description.setBorder(new EmptyBorder(4, 7, 7, 7));
        description.setHighlighter(null);
        description.setEditable(false);
        description.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Base.openURL(e.getDescription());
            }
        });
        description.addKeyListener(new DelegatingKeyListener(this.parentTable));
        panel.add((Component)description, 0);
        return description;
    }

    protected void onRemove(ContributedLibrary selected) {
    }

    protected void onInstall(ContributedLibrary selected, ContributedLibrary installed) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.parentTable = table;
        this.setEnabled(false);
        Component component = this.getUpdatedCellComponent(value, isSelected, row, false);
        if (row % 2 == 0) {
            component.setBackground(new Color(236, 241, 241));
        } else {
            component.setBackground(new Color(255, 255, 255));
        }
        int height = new Double(component.getPreferredSize().getHeight()).intValue();
        if (table.getRowHeight(row) < height) {
            table.setRowHeight(row, height);
        }
        return component;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.parentTable = table;
        this.editorValue = (ContributedLibraryReleases)value;
        this.setEnabled(true);
        ContributedLibrary installed = this.editorValue.getInstalled();
        List releases = this.editorValue.getReleases().stream().filter(new OnlyUpstreamReleasePredicate()).collect(Collectors.toList());
        List<ContributedLibrary> uninstalledReleases = releases.stream().filter(new InstalledPredicate().negate()).collect(Collectors.toList());
        List installedBuiltIn = releases.stream().filter(new InstalledPredicate()).filter(new BuiltInPredicate()).collect(Collectors.toList());
        if (installed != null && !installedBuiltIn.contains(installed)) {
            uninstalledReleases.addAll(installedBuiltIn);
        }
        Collections.sort(uninstalledReleases, new ReverseComparator((Comparator)new DownloadableContributionVersionComparator()));
        this.downgradeChooser.removeAllItems();
        this.downgradeChooser.addItem(I18n.tr((String)"Select version"));
        LinkedList uninstalledPreviousReleases = new LinkedList();
        LinkedList uninstalledNewerReleases = new LinkedList();
        VersionComparator versionComparator = new VersionComparator();
        uninstalledReleases.stream().forEach(input -> {
            if (installed == null || versionComparator.greaterThan(installed.getParsedVersion(), input.getParsedVersion())) {
                uninstalledPreviousReleases.add(input);
            } else {
                uninstalledNewerReleases.add(input);
            }
        });
        uninstalledNewerReleases.forEach(this.downgradeChooser::addItem);
        uninstalledPreviousReleases.forEach(this.downgradeChooser::addItem);
        this.downgradeChooser.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.downgradeButton.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.versionToInstallChooser.removeAllItems();
        uninstalledReleases.forEach(this.versionToInstallChooser::addItem);
        this.versionToInstallChooser.setVisible(installed == null && uninstalledReleases.size() > 1);
        Component component = this.getUpdatedCellComponent(value, true, row, !installedBuiltIn.isEmpty());
        component.setBackground(new Color(218, 227, 227));
        return component;
    }

    private Component getUpdatedCellComponent(Object value, boolean isSelected, int row, boolean hasBuiltInRelease) {
        boolean upgradable;
        boolean installable;
        ContributedLibraryReleases releases = (ContributedLibraryReleases)value;
        JTextPane description = this.makeNewDescription(this.panel);
        if (releases == null) {
            return this.panel;
        }
        ContributedLibrary selected = releases.getSelected();
        ContributedLibrary installed = releases.getInstalled();
        if (installed == null) {
            installable = true;
            upgradable = false;
        } else {
            installable = false;
            boolean bl = upgradable = new DownloadableContributionVersionComparator().compare((DownloadableContribution)selected, (DownloadableContribution)installed) > 0;
        }
        if (installable) {
            this.installButton.setText(I18n.tr((String)"Install"));
        }
        if (upgradable) {
            this.installButton.setText(I18n.tr((String)"Update"));
        }
        this.installButton.setVisible(installable || upgradable);
        this.installButtonPlaceholder.setVisible(!installable && !upgradable);
        String name = selected.getName();
        String author = selected.getAuthor();
        String website = selected.getWebsite();
        String sentence = selected.getSentence();
        String paragraph = selected.getParagraph();
        String midcolor = isSelected ? "#000000" : "#888888";
        String desc = "<html><body>";
        desc = desc + I18n.format((String)"<b>{0}</b>", (Object[])new Object[]{name});
        if (installed != null && installed.isReadOnly()) {
            desc = desc + " Built-In ";
        }
        desc = desc + I18n.format((String)"<font color=\"{0}\">", (Object[])new Object[]{midcolor});
        if (author != null && !author.isEmpty()) {
            desc = desc + I18n.format((String)" by <b>{0}</b>", (Object[])new Object[]{author});
        }
        if (installed != null) {
            String installedVer = installed.getParsedVersion();
            desc = installedVer == null ? desc + " " + I18n.tr((String)"Version unknown") : desc + " " + I18n.format((String)I18n.tr((String)"Version <b>{0}</b>"), (Object[])new Object[]{installedVer});
        }
        desc = desc + "</font>";
        if (installed != null) {
            desc = desc + " <strong><font color=\"#00979D\">INSTALLED</font></strong>";
        }
        desc = desc + "<br/>";
        if (sentence != null) {
            desc = desc + I18n.format((String)"<b>{0}</b> ", (Object[])new Object[]{sentence});
            if (paragraph != null && !paragraph.isEmpty()) {
                desc = desc + I18n.format((String)"{0}", (Object[])new Object[]{paragraph});
            }
            desc = desc + "<br />";
        }
        if (author != null && !author.isEmpty()) {
            desc = desc + I18n.format((String)"<a href=\"{0}\">More info</a>", (Object[])new Object[]{website});
        }
        desc = desc + "</body></html>";
        description.setText(desc);
        description.setBackground(Color.WHITE);
        int width = this.parentTable.getBounds().width;
        this.setJTextPaneDimensionToFitContainedText(description, width);
        if (isSelected) {
            this.panel.setBackground(this.parentTable.getSelectionBackground());
            this.panel.setForeground(this.parentTable.getSelectionForeground());
        } else {
            this.panel.setBackground(this.parentTable.getBackground());
            this.panel.setForeground(this.parentTable.getForeground());
        }
        return this.panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enable(false);
        if (enabled) {
            this.enabler.start();
        } else {
            this.enabler.stop();
        }
        this.buttonsPanel.setVisible(enabled);
        this.inactiveButtonsPanel.setVisible(!enabled);
    }

    public void enable(boolean enabled) {
        this.installButton.setEnabled(enabled);
    }

    @Override
    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public void invalidate() {
        this.panel.invalidate();
    }
}

