/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.Compiler;
import cc.arduino.UploaderUtils;
import cc.arduino.contributions.GPGDetachedSignatureVerifier;
import cc.arduino.contributions.SignatureVerificationFailedException;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.files.DeleteFilesOnShutdown;
import cc.arduino.packages.DiscoveryManager;
import cc.arduino.packages.Uploader;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.logging.impl.NoOpLog;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.SketchData;
import processing.app.debug.LegacyTargetPackage;
import processing.app.debug.LegacyTargetPlatform;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.BasicUserNotifier;
import processing.app.helpers.CommandlineParser;
import processing.app.helpers.FileUtils;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.UserNotifier;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.helpers.filefilters.OnlyFilesWithExtension;
import processing.app.legacy.PApplet;
import processing.app.packages.LibraryList;
import processing.app.packages.UserLibrary;

public class BaseNoGui {
    public static final int REVISION = 10607;
    public static final String VERSION_NAME = "1.6.7";
    public static final String VERSION_NAME_LONG;
    static String currentDirectory;
    private static DiscoveryManager discoveryManager;
    private static File examplesFolder;
    private static File toolsFolder;
    public static Map<String, LibraryList> importToLibraryTable;
    private static List<File> librariesFolders;
    static UserNotifier notifier;
    public static Map<String, TargetPackage> packages;
    static Platform platform;
    static File portableFolder;
    static final String portableSketchbookFolder = "sketchbook";
    public static ContributionsIndexer indexer;
    public static LibrariesIndexer librariesIndexer;

    public static File absoluteFile(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(currentDirectory, path);
        }
        return file;
    }

    public static int countLines(String what) {
        int count = 1;
        for (char c : what.toCharArray()) {
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public static String getAvrBasePath() {
        String path = BaseNoGui.getHardwarePath() + File.separator + "tools" + File.separator + "avr" + File.separator + "bin" + File.separator;
        if (OSUtils.isLinux() && !new File(path).exists()) {
            return "";
        }
        return path;
    }

    public static File getBuildFolder(SketchData data) throws IOException {
        File buildFolder;
        if (PreferencesData.get("build.path") != null) {
            buildFolder = BaseNoGui.absoluteFile(PreferencesData.get("build.path"));
            Files.createDirectories(buildFolder.toPath(), new FileAttribute[0]);
        } else {
            buildFolder = FileUtils.createTempFolder("build", DigestUtils.md5Hex((String)data.getMainFilePath()) + ".tmp");
            DeleteFilesOnShutdown.add(buildFolder);
        }
        return buildFolder;
    }

    public static PreferencesMap getBoardPreferences() {
        TargetBoard board = BaseNoGui.getTargetBoard();
        if (board == null) {
            return null;
        }
        String boardId = board.getId();
        PreferencesMap prefs = new PreferencesMap(board.getPreferences());
        String extendedName = (String)prefs.get("name");
        for (String menuId : board.getMenuIds()) {
            String entry;
            if (!board.hasMenu(menuId) || (entry = PreferencesData.get("custom_" + menuId)) == null || !entry.startsWith(boardId)) continue;
            String selectionId = entry.substring(boardId.length() + 1);
            prefs.putAll(board.getMenuPreferences(menuId, selectionId));
            extendedName = extendedName + ", " + board.getMenuLabel(menuId, selectionId);
        }
        prefs.put("name", extendedName);
        return prefs;
    }

    public static File getContentFile(String name) {
        String appDir = System.getProperty("APP_DIR");
        if (appDir == null || appDir.length() == 0) {
            appDir = currentDirectory;
        }
        File installationFolder = new File(appDir);
        return new File(installationFolder, name);
    }

    public static TargetPlatform getCurrentTargetPlatformFromPackage(String pack) {
        return BaseNoGui.getTargetPlatform(pack, PreferencesData.get("target_platform"));
    }

    public static File getDefaultSketchbookFolder() {
        if (BaseNoGui.getPortableFolder() != null) {
            return new File(BaseNoGui.getPortableFolder(), BaseNoGui.getPortableSketchbookFolder());
        }
        File sketchbookFolder = null;
        try {
            sketchbookFolder = BaseNoGui.getPlatform().getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sketchbookFolder;
    }

    public static DiscoveryManager getDiscoveryManager() {
        return discoveryManager;
    }

    public static File getExamplesFolder() {
        return examplesFolder;
    }

    public static String getExamplesPath() {
        return examplesFolder.getAbsolutePath();
    }

    public static File getHardwareFolder() {
        return BaseNoGui.getContentFile("hardware");
    }

    public static String getHardwarePath() {
        return BaseNoGui.getHardwareFolder().getAbsolutePath();
    }

    public static List<File> getLibrariesPath() {
        return librariesFolders;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static File getPortableFolder() {
        return portableFolder;
    }

    public static String getPortableSketchbookFolder() {
        return portableSketchbookFolder;
    }

    public static File getSettingsFile(String filename) {
        return new File(BaseNoGui.getSettingsFolder(), filename);
    }

    public static File getSettingsFolder() {
        if (BaseNoGui.getPortableFolder() != null) {
            return BaseNoGui.getPortableFolder();
        }
        File settingsFolder = null;
        String preferencesPath = PreferencesData.get("settings.path");
        if (preferencesPath != null) {
            settingsFolder = BaseNoGui.absoluteFile(preferencesPath);
        } else {
            try {
                settingsFolder = BaseNoGui.getPlatform().getSettingsFolder();
            }
            catch (Exception e) {
                BaseNoGui.showError(I18n.tr("Problem getting data folder"), I18n.tr("Error getting the Arduino data folder."), e);
            }
        }
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            BaseNoGui.showError(I18n.tr("Settings issues"), I18n.tr("Arduino cannot run because it could not\ncreate a folder to store your settings."), null);
        }
        return settingsFolder;
    }

    public static File getSketchbookFolder() {
        String sketchBookPath = PreferencesData.get("sketchbook.path");
        if (BaseNoGui.getPortableFolder() != null && !new File(sketchBookPath).isAbsolute()) {
            return new File(BaseNoGui.getPortableFolder(), sketchBookPath);
        }
        return BaseNoGui.absoluteFile(sketchBookPath);
    }

    public static File getSketchbookHardwareFolder() {
        return new File(BaseNoGui.getSketchbookFolder(), "hardware");
    }

    public static File getSketchbookLibrariesFolder() {
        File libdir = new File(BaseNoGui.getSketchbookFolder(), "libraries");
        if (!libdir.exists()) {
            FileWriter freadme = null;
            try {
                libdir.mkdirs();
                freadme = new FileWriter(new File(libdir, "readme.txt"));
                freadme.write(I18n.tr("For information on installing libraries, see: http://www.arduino.cc/en/Guide/Libraries\n"));
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(freadme);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(freadme);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)freadme);
        }
        return libdir;
    }

    public static String getSketchbookPath() {
        File sketchbookFolder;
        String sketchbookPath = PreferencesData.get("sketchbook.path");
        if (sketchbookPath != null && !(sketchbookFolder = BaseNoGui.getPortableFolder() != null && !new File(sketchbookPath).isAbsolute() ? new File(BaseNoGui.getPortableFolder(), sketchbookPath) : BaseNoGui.absoluteFile(sketchbookPath)).exists()) {
            BaseNoGui.showWarning(I18n.tr("Sketchbook folder disappeared"), I18n.tr("The sketchbook folder no longer exists.\nArduino will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Arduino will then stop talking about\nhimself in the third person."), null);
            sketchbookPath = null;
        }
        return sketchbookPath;
    }

    public static TargetBoard getTargetBoard() {
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform == null) {
            return null;
        }
        String boardId = PreferencesData.get("board");
        return targetPlatform.getBoard(boardId);
    }

    public static TargetPackage getTargetPackage(String packageName) {
        return packages.get(packageName);
    }

    public static TargetPlatform getTargetPlatform() {
        String packageName = PreferencesData.get("target_package");
        String platformName = PreferencesData.get("target_platform");
        return BaseNoGui.getTargetPlatform(packageName, platformName);
    }

    public static TargetPlatform getTargetPlatform(String packageName, String platformName) {
        TargetPackage p = packages.get(packageName);
        if (p == null) {
            return null;
        }
        return p.get(platformName);
    }

    public static File getToolsFolder() {
        return toolsFolder;
    }

    public static String getToolsPath() {
        return toolsFolder.getAbsolutePath();
    }

    public static LibraryList getUserLibs() {
        LibraryList libs = librariesIndexer.getInstalledLibraries();
        return libs.filterLibrariesInSubfolder(BaseNoGui.getSketchbookFolder());
    }

    public static String[] headerListFromIncludePath(File path) throws IOException {
        String[] list = path.list(new OnlyFilesWithExtension(".h", ".hh", ".hpp"));
        if (list == null) {
            throw new IOException();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String[] args) throws Exception {
        CommandlineParser parser = new CommandlineParser(args);
        parser.parseArgumentsPhase1();
        String sketchbookPath = BaseNoGui.getSketchbookPath();
        if (sketchbookPath == null) {
            if (BaseNoGui.getPortableFolder() != null) {
                PreferencesData.set("sketchbook.path", BaseNoGui.getPortableSketchbookFolder());
            } else {
                BaseNoGui.showError(I18n.tr("No sketchbook"), I18n.tr("Sketchbook path not defined"), null);
            }
        }
        BaseNoGui.initPackages();
        BaseNoGui.onBoardOrPortChange();
        parser.parseArgumentsPhase2();
        for (String path : parser.getFilenames()) {
            File file = BaseNoGui.absoluteFile(path);
            if (OSUtils.isWindows()) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!parser.isVerifyOrUploadMode() && !parser.isGetPrefMode()) {
                BaseNoGui.showError(I18n.tr("Mode not supported"), I18n.tr("Only --verify, --upload or --get-pref are supported"), null);
            }
            if (!parser.isForceSavePrefs()) {
                PreferencesData.setDoSave(false);
            }
            if (file.exists()) continue;
            String mess = I18n.format(I18n.tr("Failed to open sketch: \"{0}\""), path);
            BaseNoGui.showError(null, mess, 2);
        }
        PreferencesData.save();
        if (parser.isVerifyOrUploadMode()) {
            File tempBuildFolder;
            SketchData data;
            PreferencesData.set("build.verbose", "" + parser.isDoVerboseBuild());
            PreferencesData.set("upload.verbose", "" + parser.isDoVerboseUpload());
            PreferencesData.setDoSave(false);
            if (parser.isUploadMode()) {
                if (parser.getFilenames().size() != 1) {
                    BaseNoGui.showError(I18n.tr("Multiple files not supported"), I18n.tr("The --upload option supports only one file at a time"), null);
                }
                LinkedList<String> warningsAccumulator = new LinkedList<String>();
                boolean success = false;
                try {
                    String suggestedClassName;
                    data = new SketchData(BaseNoGui.absoluteFile(parser.getFilenames().get(0)));
                    tempBuildFolder = BaseNoGui.getBuildFolder(data);
                    data.load();
                    if (!data.getFolder().exists()) {
                        BaseNoGui.showError(I18n.tr("No sketch"), I18n.tr("Can't find the sketch in the specified path"), null);
                    }
                    if ((suggestedClassName = new Compiler(data, tempBuildFolder.getAbsolutePath()).build(null, false)) == null) {
                        BaseNoGui.showError(I18n.tr("Error while verifying"), I18n.tr("An error occurred while verifying the sketch"), null);
                    }
                    BaseNoGui.showMessage(I18n.tr("Done compiling"), I18n.tr("Done compiling"));
                    Uploader uploader = new UploaderUtils().getUploaderByPreferences(parser.isNoUploadPort());
                    if (uploader.requiresAuthorization() && !PreferencesData.has(uploader.getAuthorizationKey())) {
                        BaseNoGui.showError("...", "...", null);
                    }
                    try {
                        success = new UploaderUtils().upload(data, uploader, tempBuildFolder.getAbsolutePath(), suggestedClassName, parser.isDoUseProgrammer(), parser.isNoUploadPort(), warningsAccumulator);
                        BaseNoGui.showMessage(I18n.tr("Done uploading"), I18n.tr("Done uploading"));
                    }
                    finally {
                        if (uploader.requiresAuthorization() && !success) {
                            PreferencesData.remove(uploader.getAuthorizationKey());
                        }
                    }
                }
                catch (Exception e) {
                    BaseNoGui.showError(I18n.tr("Error while verifying/uploading"), I18n.tr("An error occurred while verifying/uploading the sketch"), e);
                }
                for (String warning : warningsAccumulator) {
                    System.out.print(I18n.tr("Warning"));
                    System.out.print(": ");
                    System.out.println(warning);
                }
                if (!success) {
                    BaseNoGui.showError(I18n.tr("Error while uploading"), I18n.tr("An error occurred while uploading the sketch"), null);
                }
            } else {
                for (String path : parser.getFilenames()) {
                    try {
                        String suggestedClassName;
                        data = new SketchData(BaseNoGui.absoluteFile(path));
                        tempBuildFolder = BaseNoGui.getBuildFolder(data);
                        data.load();
                        if (!data.getFolder().exists()) {
                            BaseNoGui.showError(I18n.tr("No sketch"), I18n.tr("Can't find the sketch in the specified path"), null);
                        }
                        if ((suggestedClassName = new Compiler(data, tempBuildFolder.getAbsolutePath()).build(null, false)) == null) {
                            BaseNoGui.showError(I18n.tr("Error while verifying"), I18n.tr("An error occurred while verifying the sketch"), null);
                        }
                        BaseNoGui.showMessage(I18n.tr("Done compiling"), I18n.tr("Done compiling"));
                    }
                    catch (Exception e) {
                        BaseNoGui.showError(I18n.tr("Error while verifying"), I18n.tr("An error occurred while verifying the sketch"), e);
                    }
                }
            }
            System.exit(0);
        } else if (parser.isGetPrefMode()) {
            BaseNoGui.dumpPrefs(parser);
        }
    }

    protected static void dumpPrefs(CommandlineParser parser) {
        if (parser.getGetPref() != null) {
            String value = PreferencesData.get(parser.getGetPref(), null);
            if (value != null) {
                System.out.println(value);
                System.exit(0);
            } else {
                System.exit(4);
            }
        } else {
            System.out.println("#PREFDUMP#");
            PreferencesMap prefs = PreferencesData.getMap();
            for (Map.Entry entry : prefs.entrySet()) {
                System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            System.exit(0);
        }
    }

    public static void initLogger() {
        System.setProperty("org.apache.commons.logging.Log", NoOpLog.class.getCanonicalName());
        Logger.getLogger("javax.jmdns").setLevel(Level.OFF);
    }

    public static void initPackages() throws Exception {
        indexer = new ContributionsIndexer(BaseNoGui.getSettingsFolder(), BaseNoGui.getPlatform(), new GPGDetachedSignatureVerifier());
        File indexFile = indexer.getIndexFile("package_index.json");
        File defaultPackageJsonFile = new File(BaseNoGui.getContentFile("dist"), "package_index.json");
        if (!indexFile.isFile() || defaultPackageJsonFile.isFile() && defaultPackageJsonFile.lastModified() > indexFile.lastModified()) {
            FileUtils.copyFile(defaultPackageJsonFile, indexFile);
        } else if (!indexFile.isFile()) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(indexFile);
                out.write("{ \"packages\" : [ ] }".getBytes());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)out);
        }
        File indexSignatureFile = indexer.getIndexFile("package_index.json.sig");
        File defaultPackageJsonSignatureFile = new File(BaseNoGui.getContentFile("dist"), "package_index.json.sig");
        if (!indexSignatureFile.isFile() || defaultPackageJsonSignatureFile.isFile() && defaultPackageJsonSignatureFile.lastModified() > indexSignatureFile.lastModified()) {
            FileUtils.copyFile(defaultPackageJsonSignatureFile, indexSignatureFile);
        }
        try {
            indexer.parseIndex();
        }
        catch (SignatureVerificationFailedException | JsonProcessingException e) {
            FileUtils.deleteIfExists(indexFile);
            FileUtils.deleteIfExists(indexSignatureFile);
            throw e;
        }
        indexer.syncWithFilesystem(BaseNoGui.getHardwareFolder());
        packages = new LinkedHashMap<String, TargetPackage>();
        BaseNoGui.loadHardware(BaseNoGui.getHardwareFolder());
        BaseNoGui.loadContributedHardware(indexer);
        BaseNoGui.loadHardware(BaseNoGui.getSketchbookHardwareFolder());
        BaseNoGui.createToolPreferences(indexer.getInstalledTools(), true);
        librariesIndexer = new LibrariesIndexer(BaseNoGui.getSettingsFolder());
        File librariesIndexFile = librariesIndexer.getIndexFile();
        BaseNoGui.copyStockLibraryIndexIfUpstreamIsMissing(librariesIndexFile);
        try {
            librariesIndexer.parseIndex();
        }
        catch (JsonProcessingException e) {
            FileUtils.deleteIfExists(librariesIndexFile);
            BaseNoGui.copyStockLibraryIndexIfUpstreamIsMissing(librariesIndexFile);
            librariesIndexer.parseIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyStockLibraryIndexIfUpstreamIsMissing(File librariesIndexFile) throws IOException {
        File defaultLibraryJsonFile = new File(BaseNoGui.getContentFile("dist"), "library_index.json");
        if (librariesIndexFile.isFile()) {
            if (!defaultLibraryJsonFile.isFile()) return;
            if (defaultLibraryJsonFile.lastModified() <= librariesIndexFile.lastModified()) return;
        }
        if (defaultLibraryJsonFile.isFile()) {
            FileUtils.copyFile(defaultLibraryJsonFile, librariesIndexFile);
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(librariesIndexFile);
            out.write("{ \"libraries\" : [ ] }".getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)out);
            return;
        }
        IOUtils.closeQuietly((Closeable)out);
        return;
    }

    protected static void initPlatform() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (OSUtils.isMacOS()) {
                platformClass = Class.forName("processing.app.macosx.Platform");
            } else if (OSUtils.isWindows()) {
                platformClass = Class.forName("processing.app.windows.Platform");
            } else if (OSUtils.isLinux()) {
                platformClass = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)platformClass.newInstance();
        }
        catch (Exception e) {
            BaseNoGui.showError(I18n.tr("Problem Setting the Platform"), I18n.tr("An unknown error occurred while trying to load\nplatform-specific code for your machine."), e);
        }
    }

    public static void initPortableFolder() {
        portableFolder = BaseNoGui.getContentFile("portable");
        if (!portableFolder.exists()) {
            portableFolder = null;
        }
    }

    public static void initVersion() {
        PreferencesData.set("last.ide.1.6.7.hardwarepath", BaseNoGui.getHardwarePath());
        PreferencesData.set("last.ide.1.6.7.daterun", "" + new Date().getTime() / 1000L);
    }

    public static boolean isSanitaryName(String name) {
        return BaseNoGui.sanitizeName(name).equals(name);
    }

    protected static void loadHardware(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        String[] list = folder.list(new OnlyDirs());
        if (list == null) {
            return;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        for (String target : list) {
            TargetPackage targetPackage;
            if (target.equals("tools")) continue;
            File subfolder = new File(folder, target);
            if (packages.containsKey(target)) {
                targetPackage = packages.get(target);
            } else {
                targetPackage = new LegacyTargetPackage(target);
                packages.put(target, targetPackage);
            }
            try {
                BaseNoGui.loadTargetPackage(targetPackage, subfolder);
            }
            catch (TargetPlatformException e) {
                System.out.println("WARNING: Error loading hardware folder " + new File(folder, target));
                System.out.println("  " + e.getMessage());
            }
        }
    }

    private static void loadTargetPackage(TargetPackage targetPackage, File _folder) throws TargetPlatformException {
        File[] folders = _folder.listFiles(OnlyDirs.ONLY_DIRS);
        if (folders == null) {
            return;
        }
        for (File subFolder : folders) {
            if (!subFolder.exists() || !subFolder.canRead()) continue;
            String arch = subFolder.getName();
            try {
                LegacyTargetPlatform platform = new LegacyTargetPlatform(arch, subFolder, targetPackage);
                targetPackage.getPlatforms().put(arch, platform);
            }
            catch (TargetPlatformException e) {
                System.err.println(e.getMessage());
            }
        }
        if (targetPackage.getPlatforms().size() == 0) {
            throw new TargetPlatformException(I18n.format(I18n.tr("No valid hardware definitions found in folder {0}."), _folder.getName()));
        }
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings(file);
        if (contents == null) {
            return null;
        }
        return PApplet.join(contents, "\n");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            BaseNoGui.showError(I18n.tr("No parameters"), I18n.tr("No command line parameters found"), null);
        }
        System.setProperty("java.net.useSystemProxies", "true");
        Thread deleteFilesOnShutdownThread = new Thread(DeleteFilesOnShutdown.INSTANCE);
        deleteFilesOnShutdownThread.setName("DeleteFilesOnShutdown");
        Runtime.getRuntime().addShutdownHook(deleteFilesOnShutdownThread);
        BaseNoGui.initPlatform();
        BaseNoGui.getPlatform().init();
        BaseNoGui.initPortableFolder();
        BaseNoGui.initParameters(args);
        BaseNoGui.checkInstallationFolder();
        BaseNoGui.init(args);
    }

    public static void checkInstallationFolder() {
        if (BaseNoGui.isIDEInstalledIntoSettingsFolder()) {
            BaseNoGui.showError(I18n.tr("Incorrect IDE installation folder"), I18n.tr("Your copy of the IDE is installed in a subfolder of your settings folder.\nPlease move the IDE to another folder."), 10);
        }
        if (BaseNoGui.isIDEInstalledIntoSketchbookFolder()) {
            BaseNoGui.showError(I18n.tr("Incorrect IDE installation folder"), I18n.tr("Your copy of the IDE is installed in a subfolder of your sketchbook.\nPlease move the IDE to another folder."), 10);
        }
    }

    public static boolean isIDEInstalledIntoSketchbookFolder() {
        return PreferencesData.has("sketchbook.path") && FileUtils.isSubDirectory(new File(PreferencesData.get("sketchbook.path")), new File(PreferencesData.get("runtime.ide.path")));
    }

    public static boolean isIDEInstalledIntoSettingsFolder() {
        try {
            return FileUtils.isSubDirectory(BaseNoGui.getPlatform().getSettingsFolder(), new File(PreferencesData.get("runtime.ide.path")));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void onBoardOrPortChange() {
        examplesFolder = BaseNoGui.getContentFile("examples");
        toolsFolder = BaseNoGui.getContentFile("tools");
        librariesFolders = new ArrayList<File>();
        librariesFolders.add(BaseNoGui.getContentFile("libraries"));
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform != null) {
            String referencedCore;
            TargetPlatform referencedPlatform;
            String core = BaseNoGui.getBoardPreferences().get("build.core", "arduino");
            if (core.contains(":") && (referencedPlatform = BaseNoGui.getTargetPlatform(referencedCore = core.split(":")[0], targetPlatform.getId())) != null) {
                File referencedPlatformFolder = referencedPlatform.getFolder();
                File folder = new File(referencedPlatformFolder, "libraries");
                librariesFolders.add(folder);
            }
            File platformFolder = targetPlatform.getFolder();
            File folder = new File(platformFolder, "libraries");
            librariesFolders.add(folder);
        }
        librariesFolders.add(BaseNoGui.getSketchbookLibrariesFolder());
        librariesIndexer.setSketchbookLibrariesFolder(BaseNoGui.getSketchbookLibrariesFolder());
        librariesIndexer.setLibrariesFolders(librariesFolders);
        librariesIndexer.rescanLibraries();
        BaseNoGui.populateImportToLibraryTable();
    }

    protected static void loadContributedHardware(ContributionsIndexer indexer) {
        for (TargetPackage pack : indexer.createTargetPackages()) {
            packages.put(pack.getId(), pack);
        }
    }

    public static void createToolPreferences(Collection<ContributedTool> installedTools, boolean removeOldKeys) {
        String prefix = "runtime.tools.";
        if (removeOldKeys) {
            PreferencesData.removeAllKeysWithPrefix(prefix);
        }
        for (ContributedTool tool : installedTools) {
            File installedFolder = tool.getDownloadableContribution(BaseNoGui.getPlatform()).getInstalledFolder();
            String absolutePath = installedFolder != null ? installedFolder.getAbsolutePath() : "___REMOVE___";
            PreferencesData.set(prefix + tool.getName() + ".path", absolutePath);
            PreferencesData.set(prefix + tool.getName() + "-" + tool.getVersion() + ".path", absolutePath);
        }
    }

    public static void populateImportToLibraryTable() {
        LibraryList list;
        String[] headers;
        importToLibraryTable = new HashMap<String, LibraryList>();
        for (UserLibrary lib : librariesIndexer.getInstalledLibraries()) {
            try {
                for (String header : headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder())) {
                    list = importToLibraryTable.get(header);
                    if (list == null) {
                        list = new LibraryList();
                        list.addFirst(lib);
                        importToLibraryTable.put(header, list);
                        continue;
                    }
                    UserLibrary old = (UserLibrary)list.peekFirst();
                    boolean useThisLib = true;
                    String name = header.substring(0, header.length() - 2);
                    String oldName = old.getInstalledFolder().getName();
                    String libName = lib.getInstalledFolder().getName();
                    String name_lc = name.toLowerCase();
                    String oldName_lc = oldName.toLowerCase();
                    String libName_lc = libName.toLowerCase();
                    if (!libName.equals(name)) {
                        if (oldName.equals(name)) {
                            useThisLib = false;
                        } else if (!libName.equals(name + "-master")) {
                            if (oldName.equals(name + "-master")) {
                                useThisLib = false;
                            } else if (!libName.startsWith(name)) {
                                if (oldName.startsWith(name)) {
                                    useThisLib = false;
                                } else if (!libName.endsWith(name)) {
                                    if (oldName.endsWith(name)) {
                                        useThisLib = false;
                                    } else if (!libName.contains(name)) {
                                        if (oldName.contains(name)) {
                                            useThisLib = false;
                                        } else if (!libName_lc.equals(name_lc)) {
                                            if (oldName_lc.equals(name_lc)) {
                                                useThisLib = false;
                                            } else if (!libName_lc.equals(name_lc + "-master")) {
                                                if (oldName_lc.equals(name_lc + "-master")) {
                                                    useThisLib = false;
                                                } else if (!libName_lc.startsWith(name_lc)) {
                                                    if (oldName_lc.startsWith(name_lc)) {
                                                        useThisLib = false;
                                                    } else if (!libName_lc.endsWith(name_lc)) {
                                                        if (oldName_lc.endsWith(name_lc)) {
                                                            useThisLib = false;
                                                        } else if (!libName_lc.contains(name_lc) && oldName_lc.contains(name_lc)) {
                                                            useThisLib = false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (useThisLib) {
                        list.addFirst(lib);
                        continue;
                    }
                    list.addLast(lib);
                }
            }
            catch (IOException e) {
                BaseNoGui.showWarning(I18n.tr("Error"), I18n.format("Unable to list header files in {0}", lib.getSrcFolder()), e);
            }
        }
        for (UserLibrary lib : librariesIndexer.getInstalledLibrariesWithDuplicates()) {
            try {
                for (String header : headers = BaseNoGui.headerListFromIncludePath(lib.getSrcFolder())) {
                    list = importToLibraryTable.get(header);
                    if (list == null || list.hasLibrary(lib)) continue;
                    list.addLast(lib);
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    public static void initParameters(String[] args) throws Exception {
        String preferencesFile = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("--preferences-file")) continue;
            preferencesFile = args[++i];
        }
        PreferencesData.init(BaseNoGui.absoluteFile(preferencesFile));
    }

    public static void removeDescendants(File dir) {
        if (!dir.exists()) {
            return;
        }
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (String file : files) {
            if (file.equals(".") || file.equals("..")) continue;
            File dead = new File(dir, file);
            if (!dead.isDirectory()) {
                if (PreferencesData.getBoolean("compiler.save_build_files") || dead.delete()) continue;
                System.err.println(I18n.format(I18n.tr("Could not delete {0}"), dead));
                continue;
            }
            BaseNoGui.removeDir(dead);
        }
    }

    public static void removeDir(File dir) {
        if (dir.exists()) {
            BaseNoGui.removeDescendants(dir);
            if (!dir.delete()) {
                System.err.println(I18n.format(I18n.tr("Could not delete {0}"), dir));
            }
        }
    }

    public static String sanitizeName(String origName) {
        char[] c = origName.toCharArray();
        StringBuffer buffer = new StringBuffer();
        if (c[0] >= '0' && c[0] <= '9') {
            buffer.append('_');
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'z' || c[i] >= 'A' && c[i] <= 'Z' || i > 0 && c[i] == '-' || i > 0 && c[i] == '.') {
                buffer.append(c[i]);
                continue;
            }
            buffer.append('_');
        }
        if (buffer.length() > 63) {
            buffer.setLength(63);
        }
        return buffer.toString();
    }

    public static void saveFile(String str, File file) throws IOException {
        boolean result;
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        PApplet.saveStrings(temp, new String[]{str});
        if (file.exists() && !(result = file.delete())) {
            throw new IOException(I18n.format(I18n.tr("Could not remove old version of {0}"), file.getAbsolutePath()));
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException(I18n.format(I18n.tr("Could not replace {0}"), file.getAbsolutePath()));
        }
    }

    public static void selectBoard(TargetBoard targetBoard) {
        TargetPlatform targetPlatform = targetBoard.getContainerPlatform();
        TargetPackage targetPackage = targetPlatform.getContainerPackage();
        PreferencesData.set("target_package", targetPackage.getId());
        PreferencesData.set("target_platform", targetPlatform.getId());
        PreferencesData.set("board", targetBoard.getId());
        File platformFolder = targetPlatform.getFolder();
        PreferencesData.set("runtime.platform.path", platformFolder.getAbsolutePath());
        PreferencesData.set("runtime.hardware.path", platformFolder.getParentFile().getAbsolutePath());
    }

    public static void selectSerialPort(String port) {
        PreferencesData.set("serial.port", port);
        String portFile = port;
        if (port.startsWith("/dev/")) {
            portFile = portFile.substring(5);
        }
        PreferencesData.set("serial.port.file", portFile);
    }

    public static void showError(String title, String message, int exit_code) {
        BaseNoGui.showError(title, message, null, exit_code);
    }

    public static void showError(String title, String message, Throwable e) {
        notifier.showError(title, message, e, 1);
    }

    public static void showError(String title, String message, Throwable e, int exit_code) {
        notifier.showError(title, message, e, exit_code);
    }

    public static void showMessage(String title, String message) {
        notifier.showMessage(title, message);
    }

    public static void showWarning(String title, String message, Exception e) {
        notifier.showWarning(title, message, e);
    }

    static {
        currentDirectory = System.getProperty("user.dir");
        String versionNameLong = VERSION_NAME;
        File hourlyBuildTxt = new File(BaseNoGui.getContentFile("lib"), "hourlyBuild.txt");
        if (hourlyBuildTxt.exists() && hourlyBuildTxt.canRead()) {
            versionNameLong = versionNameLong + " Hourly Build";
            try {
                versionNameLong = versionNameLong + " " + FileUtils.readFileToString(hourlyBuildTxt).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        VERSION_NAME_LONG = versionNameLong;
        discoveryManager = new DiscoveryManager();
        notifier = new BasicUserNotifier();
        portableFolder = null;
    }
}

