/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.serial.SerialBoardsLister;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;

public class SerialDiscovery
implements Discovery {
    private Timer serialBoardsListerTimer;
    private final List<BoardPort> serialBoardPorts = new LinkedList<BoardPort>();

    @Override
    public List<BoardPort> listDiscoveredBoards() {
        return this.getSerialBoardPorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BoardPort> getSerialBoardPorts() {
        List<BoardPort> list = this.serialBoardPorts;
        synchronized (list) {
            return new LinkedList<BoardPort>(this.serialBoardPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerialBoardPorts(List<BoardPort> newSerialBoardPorts) {
        List<BoardPort> list = this.serialBoardPorts;
        synchronized (list) {
            this.serialBoardPorts.clear();
            this.serialBoardPorts.addAll(newSerialBoardPorts);
        }
    }

    @Override
    public void start() {
        this.serialBoardsListerTimer = new Timer(SerialBoardsLister.class.getName());
        new SerialBoardsLister(this).start(this.serialBoardsListerTimer);
    }

    @Override
    public void stop() {
        this.serialBoardsListerTimer.purge();
    }
}

