/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.NetworkDiscovery;
import cc.arduino.packages.discoverers.SerialDiscovery;
import java.util.ArrayList;
import java.util.List;
import processing.app.I18n;

public class DiscoveryManager {
    private final List<Discovery> discoverers = new ArrayList<Discovery>();

    public DiscoveryManager() {
        this.discoverers.add(new SerialDiscovery());
        this.discoverers.add(new NetworkDiscovery());
        for (Discovery d : this.discoverers) {
            try {
                d.start();
            }
            catch (Exception e) {
                System.err.println(I18n.tr("Error starting discovery method: ") + d.getClass());
                e.printStackTrace();
            }
        }
        Thread closeHook = new Thread(() -> {
            for (Discovery d : this.discoverers) {
                try {
                    d.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        closeHook.setName("DiscoveryManager closeHook");
        Runtime.getRuntime().addShutdownHook(closeHook);
    }

    public List<BoardPort> discovery() {
        ArrayList<BoardPort> res = new ArrayList<BoardPort>();
        for (Discovery d : this.discoverers) {
            res.addAll(d.listDiscoveredBoards());
        }
        return res;
    }

    public BoardPort find(String address) {
        for (BoardPort boardPort : this.discovery()) {
            if (!boardPort.getAddress().equals(address)) continue;
            return boardPort;
        }
        return null;
    }
}

