/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.os.windows;

import cc.arduino.os.windows.FolderFinder;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;

public class FolderFinderInWindowsRegistry
extends FolderFinder {
    private final String registryPath;
    private final String registryKey;

    public FolderFinderInWindowsRegistry(FolderFinder next, String folderName, String registryPath, String registryKey) {
        super(next, folderName);
        this.registryPath = registryPath;
        this.registryKey = registryKey;
    }

    @Override
    public Path findInternal() throws Exception {
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)this.registryPath, (String)this.registryKey);
        value = value.replaceAll("%[uU][sS][eE][rR][pP][rR][oO][fF][iI][lL][eE]%", Matcher.quoteReplacement(System.getenv("USERPROFILE")));
        return Paths.get(value, new String[0]);
    }
}

