/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.Constants;
import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.SignatureVerificationFailedException;
import cc.arduino.contributions.SignatureVerifier;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTargetPackage;
import cc.arduino.contributions.packages.ContributedTargetPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributionsIndex;
import cc.arduino.contributions.packages.PackageIndexFilenameFilter;
import cc.arduino.contributions.packages.TestPackageIndexFilenameFilter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.filefilters.OnlyDirs;

public class ContributionsIndexer {
    private final File packagesFolder;
    private final File stagingFolder;
    private final File preferencesFolder;
    private final Platform platform;
    private final SignatureVerifier signatureVerifier;
    private ContributionsIndex index;

    public ContributionsIndexer(File preferencesFolder, Platform platform, SignatureVerifier signatureVerifier) {
        this.preferencesFolder = preferencesFolder;
        this.platform = platform;
        this.signatureVerifier = signatureVerifier;
        this.packagesFolder = new File(preferencesFolder, "packages");
        this.stagingFolder = new File(preferencesFolder, "staging" + File.separator + "packages");
    }

    public void parseIndex() throws Exception {
        File[] indexFiles;
        File defaultIndexFile = this.getIndexFile("package_index.json");
        if (!this.signatureVerifier.isSigned(defaultIndexFile)) {
            throw new SignatureVerificationFailedException("package_index.json");
        }
        this.index = this.parseIndex(defaultIndexFile);
        this.index.setTrusted();
        for (File indexFile : indexFiles = this.preferencesFolder.listFiles(new TestPackageIndexFilenameFilter(new PackageIndexFilenameFilter("package_index.json")))) {
            ContributionsIndex contributionsIndex = this.parseIndex(indexFile);
            this.mergeContributions(contributionsIndex, indexFile);
        }
        List<ContributedPackage> packages = this.index.getPackages();
        Collection packagesWithTools = packages.stream().filter(input -> input.getTools() != null && !input.getTools().isEmpty()).collect(Collectors.toList());
        for (ContributedPackage pack : packages) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                platform.setParentPackage(pack);
                platform.resolveToolsDependencies(packagesWithTools);
            }
        }
        this.index.fillCategories();
    }

    private void mergeContributions(ContributionsIndex contributionsIndex, File indexFile) {
        boolean signed = this.signatureVerifier.isSigned(indexFile);
        boolean trustall = PreferencesData.getBoolean("contributions.trust.all");
        for (ContributedPackage contributedPackage : contributionsIndex.getPackages()) {
            List<ContributedPlatform> platforms;
            ContributedPackage targetPackage;
            contributedPackage.setTrusted(signed || trustall);
            if (!contributedPackage.isTrusted()) {
                for (ContributedPlatform contributedPlatform : contributedPackage.getPlatforms()) {
                    contributedPlatform.setCategory("Contributed");
                }
            }
            if ((targetPackage = this.index.getPackage(contributedPackage.getName())) == null) {
                this.index.getPackages().add(contributedPackage);
                continue;
            }
            if (!contributedPackage.isTrusted() && this.isPackageNameProtected(contributedPackage)) continue;
            if (this.isPackageNameProtected(contributedPackage) && trustall) {
                System.err.println(I18n.format(I18n.tr("Warning: forced trusting untrusted contributions"), new Object[0]));
            }
            if ((platforms = contributedPackage.getPlatforms()) == null) {
                platforms = new LinkedList<ContributedPlatform>();
            }
            for (ContributedPlatform contributedPlatform : platforms) {
                ContributedPlatform platform = targetPackage.findPlatform(contributedPlatform.getArchitecture(), contributedPlatform.getVersion());
                if (platform != null) {
                    targetPackage.getPlatforms().remove(platform);
                }
                targetPackage.getPlatforms().add(contributedPlatform);
            }
            List<ContributedTool> tools = contributedPackage.getTools();
            if (tools == null) {
                tools = new LinkedList<ContributedTool>();
            }
            for (ContributedTool contributedTool : tools) {
                ContributedTool tool = targetPackage.findTool(contributedTool.getName(), contributedTool.getVersion());
                if (tool != null) {
                    targetPackage.getTools().remove(tool);
                }
                targetPackage.getTools().add(contributedTool);
            }
        }
    }

    private boolean isPackageNameProtected(ContributedPackage contributedPackage) {
        return Constants.PROTECTED_PACKAGE_NAMES.contains(contributedPackage.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContributionsIndex parseIndex(File indexFile) throws IOException {
        ContributionsIndex contributionsIndex;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(indexFile);
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new MrBeanModule());
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            mapper.configure(DeserializationFeature.EAGER_DESERIALIZER_FETCH, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            contributionsIndex = (ContributionsIndex)mapper.readValue((InputStream)inputStream, ContributionsIndex.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        return contributionsIndex;
    }

    public void syncWithFilesystem(File hardwareFolder) throws IOException {
        this.syncBuiltInHardwareFolder(hardwareFolder);
        this.syncLocalPackagesFolder();
    }

    private void syncBuiltInHardwareFolder(File hardwareFolder) throws IOException {
        if (this.index == null) {
            return;
        }
        for (File folder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            ContributedPackage pack = this.index.findPackage(folder.getName());
            if (pack == null) continue;
            this.syncBuiltInPackageWithFilesystem(pack, folder);
            File toolsFolder = new File(hardwareFolder, "tools");
            if (!toolsFolder.isDirectory()) continue;
            for (File toolFolder : toolsFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                File builtInToolsMetadata = new File(toolFolder, "builtin_tools_versions.txt");
                if (!builtInToolsMetadata.isFile()) continue;
                PreferencesMap toolsMetadata = new PreferencesMap(builtInToolsMetadata).subTree(pack.getName());
                for (Map.Entry toolMetadata : toolsMetadata.entrySet()) {
                    this.syncToolWithFilesystem(pack, toolFolder, (String)toolMetadata.getKey(), (String)toolMetadata.getValue());
                }
            }
        }
    }

    private void syncBuiltInPackageWithFilesystem(ContributedPackage pack, File hardwareFolder) throws IOException {
        for (File platformFolder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            File platformTxt = new File(platformFolder, "platform.txt");
            String version = (String)new PreferencesMap(platformTxt).get("version");
            ContributedPlatform platform = this.syncHardwareWithFilesystem(pack, platformFolder, platformFolder.getName(), version);
            if (platform == null) continue;
            platform.setReadOnly(true);
        }
    }

    private void syncLocalPackagesFolder() {
        if (!this.packagesFolder.isDirectory()) {
            return;
        }
        if (this.index == null) {
            return;
        }
        for (File folder : this.packagesFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            ContributedPackage pack = this.index.findPackage(folder.getName());
            if (pack == null) continue;
            this.syncPackageWithFilesystem(pack, folder);
        }
    }

    private void syncPackageWithFilesystem(ContributedPackage pack, File root) {
        File toolsFolder;
        File hardwareFolder = new File(root, "hardware");
        if (hardwareFolder.isDirectory()) {
            for (File platformFolder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                for (File versionFolder : platformFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                    this.syncHardwareWithFilesystem(pack, versionFolder, platformFolder.getName(), versionFolder.getName());
                }
            }
        }
        if ((toolsFolder = new File(root, "tools")).isDirectory()) {
            for (File toolFolder : toolsFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                for (File versionFolder : toolFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                    this.syncToolWithFilesystem(pack, versionFolder, toolFolder.getName(), versionFolder.getName());
                }
            }
        }
    }

    private void syncToolWithFilesystem(ContributedPackage pack, File installationFolder, String toolName, String version) {
        ContributedTool tool = pack.findTool(toolName, version);
        if (tool == null) {
            tool = pack.findResolvedTool(toolName, version);
        }
        if (tool == null) {
            return;
        }
        DownloadableContribution contrib = tool.getDownloadableContribution(this.platform);
        if (contrib == null) {
            System.err.println(tool + " seems to have no downloadable contributions for your operating system, but it is installed in\n" + installationFolder);
            return;
        }
        contrib.setInstalled(true);
        contrib.setInstalledFolder(installationFolder);
    }

    private ContributedPlatform syncHardwareWithFilesystem(ContributedPackage pack, File installationFolder, String architecture, String version) {
        ContributedPlatform platform = pack.findPlatform(architecture, version);
        if (platform != null) {
            platform.setInstalled(true);
            platform.setReadOnly(false);
            platform.setInstalledFolder(installationFolder);
        }
        return platform;
    }

    public String toString() {
        return this.index.toString();
    }

    public List<TargetPackage> createTargetPackages() {
        ArrayList<TargetPackage> packages = new ArrayList<TargetPackage>();
        if (this.index == null) {
            return packages;
        }
        for (ContributedPackage aPackage : this.index.getPackages()) {
            ContributedTargetPackage targetPackage = new ContributedTargetPackage(aPackage.getName());
            List platforms = aPackage.getPlatforms().stream().filter(new InstalledPredicate()).collect(Collectors.toList());
            Collections.sort(platforms, new DownloadableContributionBuiltInAtTheBottomComparator());
            for (ContributedPlatform platform : platforms) {
                String arch = platform.getArchitecture();
                File folder = platform.getInstalledFolder();
                try {
                    ContributedTargetPlatform targetPlatform = new ContributedTargetPlatform(arch, folder, targetPackage);
                    if (targetPackage.hasPlatform(targetPlatform)) continue;
                    targetPackage.addPlatform(targetPlatform);
                }
                catch (TargetPlatformException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (!targetPackage.hasPlatforms()) continue;
            packages.add(targetPackage);
        }
        Collections.sort(packages, (package1, package2) -> {
            assert (package1.getId() != null && package2.getId() != null);
            return package1.getId().toLowerCase().compareTo(package2.getId().toLowerCase());
        });
        return packages;
    }

    public boolean isContributedToolUsed(ContributedPlatform platformToIgnore, ContributedTool tool) {
        for (ContributedPackage pack : this.index.getPackages()) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                if (platformToIgnore.equals(platform) || !platform.isInstalled()) continue;
                for (ContributedTool requiredTool : platform.getResolvedTools()) {
                    if (!requiredTool.equals(tool)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<ContributedTool> getInstalledTools() {
        HashSet<ContributedTool> tools = new HashSet<ContributedTool>();
        if (this.index == null) {
            return tools;
        }
        for (ContributedPackage pack : this.index.getPackages()) {
            Collection platforms = pack.getPlatforms().stream().filter(new InstalledPredicate()).collect(Collectors.toList());
            Map<String, List<ContributedPlatform>> platformsByName = platforms.stream().collect(Collectors.groupingBy(ContributedPlatform::getName));
            platformsByName.forEach((platformName, platformsWithName) -> {
                if (platformsWithName.size() > 1) {
                    platformsWithName = platformsWithName.stream().filter(new BuiltInPredicate().negate()).collect(Collectors.toList());
                }
                for (ContributedPlatform platform : platformsWithName) {
                    tools.addAll(platform.getResolvedTools());
                }
            });
        }
        return tools;
    }

    public ContributionsIndex getIndex() {
        return this.index;
    }

    public File getPackagesFolder() {
        return this.packagesFolder;
    }

    public File getStagingFolder() {
        return this.stagingFolder;
    }

    public File getIndexFile(String name) {
        return new File(this.preferencesFolder, name);
    }

    public List<ContributedPackage> getPackages() {
        if (this.index == null) {
            return new LinkedList<ContributedPackage>();
        }
        return this.index.getPackages();
    }

    public List<String> getCategories() {
        if (this.index == null) {
            return new LinkedList<String>();
        }
        return this.index.getCategories();
    }

    public ContributedPlatform getInstalled(String packageName, String platformArch) {
        if (this.index == null) {
            return null;
        }
        return this.index.getInstalledPlatform(packageName, platformArch);
    }

    private List<ContributedPlatform> getInstalledPlatforms() {
        if (this.index == null) {
            return new LinkedList<ContributedPlatform>();
        }
        return this.index.getInstalledPlatforms();
    }

    public boolean isFolderInsidePlatform(File folder) {
        return this.getPlatformByFolder(folder) != null;
    }

    public ContributedPlatform getPlatformByFolder(File folder) {
        Optional<ContributedPlatform> platformOptional = this.getInstalledPlatforms().stream().filter(contributedPlatform -> {
            assert (contributedPlatform.getInstalledFolder() != null);
            return FileUtils.isSubDirectory(contributedPlatform.getInstalledFolder(), folder);
        }).findFirst();
        return platformOptional.orElse(null);
    }
}

