/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.DownloadableContributionWithVersionPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.filters.PlatformArchitecturePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ContributionsIndex {
    private final List<String> categories = new ArrayList<String>();

    public abstract List<ContributedPackage> getPackages();

    public ContributedPackage findPackage(String packageName) {
        for (ContributedPackage pack : this.getPackages()) {
            if (!pack.getName().equals(packageName)) continue;
            return pack;
        }
        return null;
    }

    public List<ContributedPlatform> findPlatforms(String packageName, String platformArch) {
        if (packageName == null || platformArch == null) {
            return null;
        }
        ContributedPackage aPackage = this.findPackage(packageName);
        if (aPackage == null) {
            return null;
        }
        return aPackage.getPlatforms().stream().filter(new PlatformArchitecturePredicate(platformArch)).collect(Collectors.toList());
    }

    public ContributedPlatform findPlatform(String packageName, String platformArch, String platformVersion) {
        if (platformVersion == null) {
            return null;
        }
        List<ContributedPlatform> platformsByName = this.findPlatforms(packageName, platformArch);
        if (platformsByName == null) {
            return null;
        }
        Collection platforms = platformsByName.stream().filter(new DownloadableContributionWithVersionPredicate(platformVersion)).collect(Collectors.toList());
        if (platforms.isEmpty()) {
            return null;
        }
        return (ContributedPlatform)platforms.iterator().next();
    }

    public List<ContributedPlatform> getInstalledPlatforms() {
        return this.getPlatforms().stream().filter(new InstalledPredicate()).collect(Collectors.toList());
    }

    public ContributedPlatform getInstalledPlatform(String packageName, String platformArch) {
        List<ContributedPlatform> platforms = this.findPlatforms(packageName, platformArch);
        if (platforms == null) {
            return null;
        }
        List installedPlatforms = platforms.stream().filter(new InstalledPredicate()).collect(Collectors.toList());
        Collections.sort(installedPlatforms, new DownloadableContributionBuiltInAtTheBottomComparator());
        if (installedPlatforms.isEmpty()) {
            return null;
        }
        return (ContributedPlatform)installedPlatforms.get(0);
    }

    private List<ContributedPlatform> getPlatforms() {
        return this.getPackages().stream().map(ContributedPackage::getPlatforms).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void fillCategories() {
        this.categories.clear();
        for (ContributedPackage pack : this.getPackages()) {
            pack.getPlatforms().stream().filter(platform -> !this.categories.contains(platform.getCategory())).forEach(platform -> this.categories.add(platform.getCategory()));
        }
    }

    public ContributedPackage getPackage(String packageName) {
        for (ContributedPackage pack : this.getPackages()) {
            if (!pack.getName().equals(packageName)) continue;
            return pack;
        }
        return null;
    }

    public String toString() {
        String res = "";
        res = res + "Categories: ";
        for (String c : this.getCategories()) {
            res = res + "'" + c + "' ";
        }
        res = res + "\n";
        for (ContributedPackage pack : this.getPackages()) {
            res = res + pack + "\n";
        }
        return res;
    }

    public void setTrusted() {
        this.getPackages().stream().forEach(pack -> pack.setTrusted(true));
    }
}

