/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.Constants;
import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionsDownloader;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.SignatureVerifier;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributedToolReference;
import cc.arduino.contributions.packages.PackageIndexFilenameFilter;
import cc.arduino.filters.FileExecutablePredicate;
import cc.arduino.utils.ArchiveExtractor;
import cc.arduino.utils.MultiStepProgress;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;
import processing.app.helpers.filefilters.OnlyDirs;

public class ContributionInstaller {
    private final Platform platform;
    private final SignatureVerifier signatureVerifier;

    public ContributionInstaller(Platform platform, SignatureVerifier signatureVerifier) {
        this.platform = platform;
        this.signatureVerifier = signatureVerifier;
    }

    public synchronized List<String> install(ContributedPlatform contributedPlatform, ProgressListener progressListener) throws Exception {
        LinkedList<String> errors = new LinkedList<String>();
        if (contributedPlatform.isInstalled()) {
            throw new Exception("Platform is already installed!");
        }
        LinkedList<ContributedTool> tools = new LinkedList<ContributedTool>(contributedPlatform.getResolvedTools());
        Iterator toolsIterator = tools.iterator();
        while (toolsIterator.hasNext()) {
            ContributedTool tool = (ContributedTool)toolsIterator.next();
            DownloadableContribution downloadable = tool.getDownloadableContribution(this.platform);
            if (downloadable == null) {
                throw new Exception(I18n.format(I18n.tr("Tool {0} is not available for your operating system."), tool.getName()));
            }
            if (!downloadable.isInstalled()) continue;
            toolsIterator.remove();
        }
        DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.indexer.getStagingFolder());
        MultiStepProgress progress = new MultiStepProgress((tools.size() + 1) * 2);
        try {
            downloader.download(contributedPlatform, progress, I18n.tr("Downloading boards definitions."), progressListener);
            progress.stepDone();
            int i = 1;
            for (ContributedTool tool : tools) {
                String msg = I18n.format(I18n.tr("Downloading tools ({0}/{1})."), i, tools.size());
                ++i;
                downloader.download(tool.getDownloadableContribution(this.platform), progress, msg, progressListener);
                progress.stepDone();
            }
        }
        catch (InterruptedException e) {
            return errors;
        }
        ContributedPackage pack = contributedPlatform.getParentPackage();
        File packageFolder = new File(BaseNoGui.indexer.getPackagesFolder(), pack.getName());
        List resolvedToolReferences = contributedPlatform.getResolvedToolReferences().entrySet().stream().filter(entry -> !((ContributedTool)entry.getValue()).getDownloadableContribution(this.platform).isInstalled()).collect(Collectors.toList());
        int i = 1;
        for (Map.Entry entry2 : resolvedToolReferences) {
            progress.setStatus(I18n.format(I18n.tr("Installing tools ({0}/{1})..."), i, resolvedToolReferences.size()));
            progressListener.onProgress(progress);
            ++i;
            ContributedTool tool = (ContributedTool)entry2.getValue();
            DownloadableContribution toolContrib = tool.getDownloadableContribution(this.platform);
            Path destFolder = Paths.get(BaseNoGui.indexer.getPackagesFolder().getAbsolutePath(), ((ContributedToolReference)entry2.getKey()).getPackager(), "tools", tool.getName(), tool.getVersion());
            Files.createDirectories(destFolder, new FileAttribute[0]);
            assert (toolContrib.getDownloadedFile() != null);
            new ArchiveExtractor(this.platform).extract(toolContrib.getDownloadedFile(), destFolder.toFile(), 1);
            try {
                this.findAndExecutePostInstallScriptIfAny(destFolder.toFile(), contributedPlatform.getParentPackage().isTrusted(), PreferencesData.getBoolean("contributions.trust.all"));
            }
            catch (IOException e) {
                errors.add(I18n.tr("Error running post install script"));
            }
            toolContrib.setInstalled(true);
            toolContrib.setInstalledFolder(destFolder.toFile());
            progress.stepDone();
        }
        progress.setStatus(I18n.tr("Installing boards..."));
        progressListener.onProgress(progress);
        File platformFolder = new File(packageFolder, "hardware" + File.separator + contributedPlatform.getArchitecture());
        File destFolder = new File(platformFolder, contributedPlatform.getParsedVersion());
        Files.createDirectories(destFolder.toPath(), new FileAttribute[0]);
        new ArchiveExtractor(this.platform).extract(contributedPlatform.getDownloadedFile(), destFolder, 1);
        contributedPlatform.setInstalled(true);
        contributedPlatform.setInstalledFolder(destFolder);
        try {
            this.findAndExecutePostInstallScriptIfAny(destFolder, contributedPlatform.getParentPackage().isTrusted(), PreferencesData.getBoolean("contributions.trust.all"));
        }
        catch (IOException e) {
            e.printStackTrace();
            errors.add(I18n.tr("Error running post install script"));
        }
        progress.stepDone();
        progress.setStatus(I18n.tr("Installation completed!"));
        progressListener.onProgress(progress);
        return errors;
    }

    private void findAndExecutePostInstallScriptIfAny(File folder, boolean trusted, boolean trustAll) throws IOException {
        Collection scripts = this.platform.postInstallScripts(folder).stream().filter(new FileExecutablePredicate()).collect(Collectors.toList());
        if (scripts.isEmpty()) {
            String[] subfolders = folder.list(new OnlyDirs());
            if (subfolders.length != 1) {
                return;
            }
            this.findAndExecutePostInstallScriptIfAny(new File(folder, subfolders[0]), trusted, trustAll);
            return;
        }
        this.executeScripts(folder, scripts, trusted, trustAll);
    }

    private void findAndExecutePreUninstallScriptIfAny(File folder, boolean trusted, boolean trustAll) throws IOException {
        Collection scripts = this.platform.preUninstallScripts(folder).stream().filter(new FileExecutablePredicate()).collect(Collectors.toList());
        if (scripts.isEmpty()) {
            String[] subfolders = folder.list(new OnlyDirs());
            if (subfolders.length != 1) {
                return;
            }
            this.findAndExecutePreUninstallScriptIfAny(new File(folder, subfolders[0]), trusted, trustAll);
            return;
        }
        this.executeScripts(folder, scripts, trusted, trustAll);
    }

    private void executeScripts(File folder, Collection<File> postInstallScripts, boolean trusted, boolean trustAll) throws IOException {
        File script = postInstallScripts.iterator().next();
        if (!trusted && !trustAll) {
            System.err.println(I18n.format(I18n.tr("Warning: non trusted contribution, skipping script execution ({0})"), script));
            return;
        }
        if (trustAll) {
            System.err.println(I18n.format(I18n.tr("Warning: forced untrusted script execution ({0})"), script));
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdout, (OutputStream)stderr));
        executor.setWorkingDirectory(folder);
        executor.setExitValues(null);
        int exitValue = executor.execute(new CommandLine(script));
        executor.setExitValues(new int[0]);
        System.out.write(stdout.toByteArray());
        System.err.write(stderr.toByteArray());
        if (executor.isFailure(exitValue)) {
            throw new IOException();
        }
    }

    public synchronized List<String> remove(ContributedPlatform contributedPlatform) {
        BaseNoGui.indexer.getPackages().stream().flatMap(p -> p.getPlatforms().stream()).filter(new InstalledPredicate()).collect(Collectors.toList());
        if (contributedPlatform == null || contributedPlatform.isReadOnly()) {
            return new LinkedList<String>();
        }
        LinkedList<String> errors = new LinkedList<String>();
        try {
            this.findAndExecutePreUninstallScriptIfAny(contributedPlatform.getInstalledFolder(), contributedPlatform.getParentPackage().isTrusted(), PreferencesData.getBoolean("contributions.trust.all"));
        }
        catch (IOException e) {
            errors.add(I18n.tr("Error running post install script"));
        }
        for (ContributedTool tool : contributedPlatform.getResolvedTools()) {
            if (BaseNoGui.indexer.isContributedToolUsed(contributedPlatform, tool)) continue;
            DownloadableContribution toolContrib = tool.getDownloadableContribution(this.platform);
            File destFolder = toolContrib.getInstalledFolder();
            FileUtils.recursiveDelete(destFolder);
            toolContrib.setInstalled(false);
            toolContrib.setInstalledFolder(null);
            try {
                Files.delete(destFolder.getParentFile().toPath());
            }
            catch (Exception exception) {}
        }
        FileUtils.recursiveDelete(contributedPlatform.getInstalledFolder());
        contributedPlatform.setInstalled(false);
        contributedPlatform.setInstalledFolder(null);
        return errors;
    }

    public synchronized List<String> updateIndex(ProgressListener progressListener) throws Exception {
        MultiStepProgress progress = new MultiStepProgress(1);
        LinkedList<String> downloadedPackageIndexFilesAccumulator = new LinkedList<String>();
        this.downloadIndexAndSignature(progress, downloadedPackageIndexFilesAccumulator, Constants.PACKAGE_INDEX_URL, progressListener);
        HashSet<String> packageIndexURLs = new HashSet<String>();
        String additionalURLs = PreferencesData.get("boardsmanager.additional.urls", "");
        if (!"".equals(additionalURLs)) {
            packageIndexURLs.addAll(Arrays.asList(additionalURLs.split(",")));
        }
        for (String packageIndexURL : packageIndexURLs) {
            try {
                this.downloadIndexAndSignature(progress, downloadedPackageIndexFilesAccumulator, packageIndexURL, progressListener);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        progress.stepDone();
        return downloadedPackageIndexFilesAccumulator;
    }

    private void downloadIndexAndSignature(MultiStepProgress progress, List<String> downloadedPackagedIndexFilesAccumulator, String packageIndexUrl, ProgressListener progressListener) throws Exception {
        File packageIndex = this.download(progress, packageIndexUrl, progressListener);
        downloadedPackagedIndexFilesAccumulator.add(packageIndex.getName());
        try {
            File packageIndexSignature = this.download(progress, packageIndexUrl + ".sig", progressListener);
            boolean signatureVerified = this.signatureVerifier.isSigned(packageIndex);
            if (signatureVerified) {
                downloadedPackagedIndexFilesAccumulator.add(packageIndexSignature.getName());
            } else {
                downloadedPackagedIndexFilesAccumulator.remove(packageIndex.getName());
                Files.delete(packageIndex.toPath());
                Files.delete(packageIndexSignature.toPath());
                System.err.println(I18n.format(I18n.tr("{0} file signature verification failed. File ignored."), packageIndexUrl));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File download(MultiStepProgress progress, String packageIndexUrl, ProgressListener progressListener) throws Exception {
        String statusText = I18n.tr("Downloading platforms index...");
        URL url = new URL(packageIndexUrl);
        String[] urlPathParts = url.getFile().split("/");
        File outputFile = BaseNoGui.indexer.getIndexFile(urlPathParts[urlPathParts.length - 1]);
        File tmpFile = new File(outputFile.getAbsolutePath() + ".tmp");
        DownloadableContributionsDownloader downloader = new DownloadableContributionsDownloader(BaseNoGui.indexer.getStagingFolder());
        downloader.download(url, tmpFile, progress, statusText, progressListener);
        Files.deleteIfExists(outputFile.toPath());
        Files.move(tmpFile.toPath(), outputFile.toPath(), new CopyOption[0]);
        return outputFile;
    }

    public synchronized void deleteUnknownFiles(List<String> downloadedPackageIndexFiles) throws IOException {
        File preferencesFolder = BaseNoGui.indexer.getIndexFile(".").getParentFile();
        File[] additionalPackageIndexFiles = preferencesFolder.listFiles(new PackageIndexFilenameFilter("package_index.json"));
        if (additionalPackageIndexFiles == null) {
            return;
        }
        for (File additionalPackageIndexFile : additionalPackageIndexFiles) {
            if (downloadedPackageIndexFiles.contains(additionalPackageIndexFile.getName())) continue;
            Files.delete(additionalPackageIndexFile.toPath());
        }
    }
}

