/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.packages.HostDependentDownloadableContribution;
import java.util.List;
import processing.app.Platform;

public abstract class ContributedTool {
    public abstract String getName();

    public abstract String getVersion();

    public abstract List<HostDependentDownloadableContribution> getSystems();

    public DownloadableContribution getDownloadableContribution(Platform platform) {
        for (HostDependentDownloadableContribution c : this.getSystems()) {
            if (!c.isCompatible(platform)) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Platform platform) {
        String res = "Tool name : " + this.getName() + " " + this.getVersion() + "\n";
        for (HostDependentDownloadableContribution sys : this.getSystems()) {
            res = res + "     sys";
            if (platform != null) {
                res = res + (sys.isCompatible(platform) ? "*" : " ");
            }
            res = res + " : " + sys + "\n";
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributedTool)) {
            return false;
        }
        ContributedTool obj1 = (ContributedTool)obj;
        return this.getName().equals(obj1.getName()) && this.getVersion().equals(obj1.getVersion());
    }
}

