/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import cc.arduino.CompilerProgressListener;
import cc.arduino.MessageConsumerOutputStream;
import cc.arduino.MyStreamPumper;
import cc.arduino.ProgressAwareMessageConsumer;
import cc.arduino.i18n.I18NAwareMessageConsumer;
import cc.arduino.packages.BoardPort;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SketchCode;
import processing.app.SketchData;
import processing.app.debug.MessageConsumer;
import processing.app.debug.RunnerException;
import processing.app.debug.Sizer;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.StringReplacer;
import processing.app.legacy.PApplet;
import processing.app.tools.DoubleQuotedArgumentsOnWindowsCommandLine;

public class Compiler
implements MessageConsumer {
    private static final Pattern ERROR_FORMAT;
    private final String pathToSketch;
    private final SketchData sketch;
    private final String buildPath;
    private final boolean verbose;
    private RunnerException exception;

    public Compiler(SketchData data, String buildPath) {
        this(data.getMainFilePath(), data, buildPath);
    }

    public Compiler(String pathToSketch, SketchData sketch, String buildPath) {
        this.pathToSketch = pathToSketch;
        this.sketch = sketch;
        this.buildPath = buildPath;
        this.verbose = PreferencesData.getBoolean("build.verbose");
    }

    public String build(CompilerProgressListener progListener, boolean exportHex) throws RunnerException, PreferencesMapException, IOException {
        TargetBoard board = BaseNoGui.getTargetBoard();
        if (board == null) {
            throw new RunnerException("Board is not selected");
        }
        TargetPlatform platform = board.getContainerPlatform();
        TargetPackage aPackage = platform.getContainerPackage();
        String vidpid = this.VIDPID();
        PreferencesMap prefs = this.loadPreferences(board, platform, aPackage, vidpid);
        MessageConsumerOutputStream out = new MessageConsumerOutputStream(new ProgressAwareMessageConsumer(new I18NAwareMessageConsumer(System.out, System.err), progListener), "\n");
        MessageConsumerOutputStream err = new MessageConsumerOutputStream(new I18NAwareMessageConsumer(System.err, this), "\n");
        this.callArduinoBuilder(board, platform, aPackage, vidpid, BuilderAction.COMPILE, new PumpStreamHandler((OutputStream)out, (OutputStream)err));
        out.flush();
        err.flush();
        if (exportHex) {
            this.runActions("hooks.savehex.presavehex", prefs);
            this.saveHex(prefs);
            this.runActions("hooks.savehex.postsavehex", prefs);
        }
        this.size(prefs);
        return this.sketch.getPrimaryFile().getName();
    }

    private String VIDPID() {
        BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get("serial.port"));
        if (boardPort == null) {
            return "";
        }
        String vid = (String)boardPort.getPrefs().get("vid");
        String pid = (String)boardPort.getPrefs().get("pid");
        if (StringUtils.isEmpty((CharSequence)vid) || StringUtils.isEmpty((CharSequence)pid)) {
            return "";
        }
        return vid.toUpperCase() + "_" + pid.toUpperCase();
    }

    private PreferencesMap loadPreferences(TargetBoard board, TargetPlatform platform, TargetPackage aPackage, String vidpid) throws RunnerException, IOException {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        MessageConsumerOutputStream err = new MessageConsumerOutputStream(new I18NAwareMessageConsumer(new PrintStream(stderr), this), "\n");
        try {
            this.callArduinoBuilder(board, platform, aPackage, vidpid, BuilderAction.DUMP_PREFS, new PumpStreamHandler((OutputStream)stdout, (OutputStream)err));
        }
        catch (RunnerException e) {
            System.err.println(new String(stderr.toByteArray()));
            throw e;
        }
        PreferencesMap prefs = new PreferencesMap();
        prefs.load(new ByteArrayInputStream(stdout.toByteArray()));
        return prefs;
    }

    private void callArduinoBuilder(TargetBoard board, TargetPlatform platform, TargetPackage aPackage, String vidpid, BuilderAction action, PumpStreamHandler streamHandler) throws RunnerException {
        int result;
        File executable = BaseNoGui.getContentFile("arduino-builder");
        CommandLine commandLine = new CommandLine(executable);
        commandLine.addArgument(action.value, false);
        commandLine.addArgument("-logger=machine", false);
        Stream.of(BaseNoGui.getHardwarePath(), new File(BaseNoGui.getSettingsFolder(), "packages").getAbsolutePath(), BaseNoGui.getSketchbookHardwareFolder().getAbsolutePath()).forEach(p -> {
            if (Files.exists(Paths.get(p, new String[0]), new LinkOption[0])) {
                commandLine.addArgument("-hardware", false);
                commandLine.addArgument("\"" + p + "\"", false);
            }
        });
        Stream.of(BaseNoGui.getContentFile("tools-builder").getAbsolutePath(), Paths.get(BaseNoGui.getHardwarePath(), "tools", "avr").toAbsolutePath().toString(), new File(BaseNoGui.getSettingsFolder(), "packages").getAbsolutePath()).forEach(p -> {
            if (Files.exists(Paths.get(p, new String[0]), new LinkOption[0])) {
                commandLine.addArgument("-tools", false);
                commandLine.addArgument("\"" + p + "\"", false);
            }
        });
        commandLine.addArgument("-built-in-libraries", false);
        commandLine.addArgument("\"" + BaseNoGui.getContentFile("libraries").getAbsolutePath() + "\"", false);
        commandLine.addArgument("-libraries", false);
        commandLine.addArgument("\"" + BaseNoGui.getSketchbookLibrariesFolder().getAbsolutePath() + "\"", false);
        String fqbn = Stream.of(aPackage.getId(), platform.getId(), board.getId(), this.boardOptions(board)).filter(s -> !s.isEmpty()).collect(Collectors.joining(":"));
        commandLine.addArgument("-fqbn=" + fqbn, false);
        if (!"".equals(vidpid)) {
            commandLine.addArgument("-vid-pid=" + vidpid, false);
        }
        commandLine.addArgument("-ide-version=10607", false);
        commandLine.addArgument("-build-path", false);
        commandLine.addArgument("\"" + this.buildPath + "\"", false);
        commandLine.addArgument("-warnings=" + PreferencesData.get("compiler.warning_level"), false);
        PreferencesData.getMap().subTree("build_properties_custom").entrySet().stream().forEach(kv -> commandLine.addArgument("-prefs=\"" + (String)kv.getKey() + "=" + (String)kv.getValue() + "\"", false));
        commandLine.addArgument("-prefs=build.warn_data_percentage=" + PreferencesData.get("build.warn_data_percentage"));
        if (this.verbose) {
            commandLine.addArgument("-verbose", false);
        }
        commandLine.addArgument("\"" + this.pathToSketch + "\"", false);
        if (this.verbose) {
            System.out.println(commandLine);
        }
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        executor.setExitValues(null);
        try {
            result = executor.execute(commandLine);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        executor.setExitValues(new int[0]);
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(I18n.format(I18n.tr("{0} returned {1}"), executable.getName(), result));
        }
        if (result != 0) {
            RunnerException re = new RunnerException(I18n.tr("Error compiling."));
            re.hideStackTrace();
            throw re;
        }
    }

    private void size(PreferencesMap prefs) throws RunnerException {
        long[] sizes;
        String maxTextSizeString = (String)prefs.get("upload.maximum_size");
        String maxDataSizeString = (String)prefs.get("upload.maximum_data_size");
        if (maxTextSizeString == null) {
            return;
        }
        long maxTextSize = Integer.parseInt(maxTextSizeString);
        long maxDataSize = -1L;
        if (maxDataSizeString != null) {
            maxDataSize = Integer.parseInt(maxDataSizeString);
        }
        Sizer sizer = new Sizer(prefs);
        try {
            sizes = sizer.computeSize();
        }
        catch (RunnerException e) {
            System.err.println(I18n.format(I18n.tr("Couldn't determine program size: {0}"), e.getMessage()));
            return;
        }
        long textSize = sizes[0];
        long dataSize = sizes[1];
        System.out.println();
        System.out.println(I18n.format(I18n.tr("Sketch uses {0} bytes ({2}%%) of program storage space. Maximum is {1} bytes."), textSize, maxTextSize, textSize * 100L / maxTextSize));
        if (dataSize >= 0L) {
            if (maxDataSize > 0L) {
                System.out.println(I18n.format(I18n.tr("Global variables use {0} bytes ({2}%%) of dynamic memory, leaving {3} bytes for local variables. Maximum is {1} bytes."), dataSize, maxDataSize, dataSize * 100L / maxDataSize, maxDataSize - dataSize));
            } else {
                System.out.println(I18n.format(I18n.tr("Global variables use {0} bytes of dynamic memory."), dataSize));
            }
        }
        if (textSize > maxTextSize) {
            throw new RunnerException(I18n.tr("Sketch too big; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing it."));
        }
        if (maxDataSize > 0L && dataSize > maxDataSize) {
            throw new RunnerException(I18n.tr("Not enough memory; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing your footprint."));
        }
        int warnDataPercentage = Integer.parseInt((String)prefs.get("build.warn_data_percentage"));
        if (maxDataSize > 0L && dataSize > maxDataSize * (long)warnDataPercentage / 100L) {
            System.err.println(I18n.tr("Low memory available, stability problems may occur."));
        }
    }

    private void saveHex(PreferencesMap prefs) throws RunnerException {
        ArrayList<String> copyOfCompiledSketches;
        ArrayList<String> compiledSketches = new ArrayList<String>(prefs.subTree("recipe.output.tmp_file", 1).values());
        if (this.isExportCompiledSketchSupported(compiledSketches, copyOfCompiledSketches = new ArrayList<String>(prefs.subTree("recipe.output.save_file", 1).values()), prefs)) {
            System.err.println(I18n.tr("Warning: This core does not support exporting sketches. Please consider upgrading it or contacting its author"));
            return;
        }
        PreferencesMap dict = new PreferencesMap(prefs);
        dict.put("ide_version", "10607");
        PreferencesMap withBootloaderDict = new PreferencesMap(dict);
        dict.put("build.project_name", (String)dict.get("build.project_name") + ".with_bootloader");
        if (!compiledSketches.isEmpty()) {
            for (int i = 0; i < compiledSketches.size(); ++i) {
                this.saveHex((String)compiledSketches.get(i), (String)copyOfCompiledSketches.get(i), dict);
                this.saveHex((String)compiledSketches.get(i), (String)copyOfCompiledSketches.get(i), withBootloaderDict);
            }
        } else {
            try {
                this.saveHex(prefs.getOrExcept("recipe.output.tmp_file"), prefs.getOrExcept("recipe.output.save_file"), dict);
                this.saveHex(prefs.getOrExcept("recipe.output.tmp_file"), prefs.getOrExcept("recipe.output.save_file"), withBootloaderDict);
            }
            catch (PreferencesMapException e) {
                throw new RunnerException(e);
            }
        }
    }

    private void saveHex(String compiledSketch, String copyOfCompiledSketch, PreferencesMap prefs) throws RunnerException {
        try {
            Path compiledSketchPath;
            compiledSketch = StringReplacer.replaceFromMapping(compiledSketch, prefs);
            copyOfCompiledSketch = StringReplacer.replaceFromMapping(copyOfCompiledSketch, prefs);
            copyOfCompiledSketch = copyOfCompiledSketch.replaceAll(":", "_");
            Path compiledSketchPathInSubfolder = Paths.get((String)prefs.get("build.path"), "sketch", compiledSketch);
            Path compiledSketchPathInBuildPath = Paths.get((String)prefs.get("build.path"), compiledSketch);
            if (Files.exists(compiledSketchPathInSubfolder, new LinkOption[0])) {
                compiledSketchPath = compiledSketchPathInSubfolder;
            } else if (Files.exists(compiledSketchPathInBuildPath, new LinkOption[0])) {
                compiledSketchPath = compiledSketchPathInBuildPath;
            } else {
                return;
            }
            Path copyOfCompiledSketchFilePath = Paths.get(this.sketch.getFolder().getAbsolutePath(), copyOfCompiledSketch);
            Files.copy(compiledSketchPath, copyOfCompiledSketchFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RunnerException(e);
        }
    }

    private boolean isExportCompiledSketchSupported(List<String> compiledSketches, List<String> copyOfCompiledSketches, PreferencesMap prefs) {
        return !(!compiledSketches.isEmpty() && !copyOfCompiledSketches.isEmpty() && copyOfCompiledSketches.size() >= compiledSketches.size() || prefs.containsKey("recipe.output.tmp_file") && prefs.containsKey("recipe.output.save_file"));
    }

    private void runActions(String recipeClass, PreferencesMap prefs) throws RunnerException, PreferencesMapException {
        List patterns = prefs.keySet().stream().filter(key -> key.startsWith("recipe." + recipeClass) && key.endsWith(".pattern")).collect(Collectors.toList());
        Collections.sort(patterns);
        for (String recipe : patterns) {
            this.runRecipe(recipe, prefs);
        }
    }

    private void runRecipe(String recipe, PreferencesMap prefs) throws RunnerException, PreferencesMapException {
        String[] cmdArray;
        PreferencesMap dict = new PreferencesMap(prefs);
        dict.put("ide_version", "10607");
        dict.put("sketch_path", this.sketch.getFolder().getAbsolutePath());
        String cmd = prefs.getOrExcept(recipe);
        try {
            cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        this.exec(cmdArray);
    }

    private void exec(String[] command) throws RunnerException {
        int result;
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : command) {
            if ((string = string.trim()).length() == 0) continue;
            stringList.add(string);
        }
        command = stringList.toArray(new String[stringList.size()]);
        if (command.length == 0) {
            return;
        }
        if (this.verbose) {
            for (String c : command) {
                System.out.print(c + " ");
            }
            System.out.println();
        }
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(){

            protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
                Thread result = new Thread(new MyStreamPumper(is, Compiler.this));
                result.setName("MyStreamPumper Thread");
                result.setDaemon(true);
                return result;
            }
        });
        DoubleQuotedArgumentsOnWindowsCommandLine commandLine = new DoubleQuotedArgumentsOnWindowsCommandLine(command[0]);
        for (int i = 1; i < command.length; ++i) {
            commandLine.addArgument(command[i], false);
        }
        executor.setExitValues(null);
        try {
            result = executor.execute((CommandLine)commandLine);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        executor.setExitValues(new int[0]);
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(I18n.format(I18n.tr("{0} returned {1}"), command[0], result));
        }
        if (result != 0) {
            RunnerException re = new RunnerException(I18n.tr("Error compiling."));
            re.hideStackTrace();
            throw re;
        }
    }

    private String boardOptions(TargetBoard board) {
        return board.getMenuIds().stream().filter(board::hasMenu).filter(menuId -> {
            String entry = PreferencesData.get("custom_" + menuId);
            return entry != null && entry.startsWith(board.getId());
        }).map(menuId -> {
            String entry = PreferencesData.get("custom_" + menuId);
            String selectionId = entry.substring(board.getId().length() + 1);
            return menuId + "=" + selectionId;
        }).collect(Collectors.joining(","));
    }

    @Override
    public void message(String s) {
        String error;
        String[] pieces;
        if (!this.verbose) {
            int i;
            while ((i = s.indexOf(this.buildPath + File.separator)) != -1) {
                s = s.substring(0, i) + s.substring(i + (this.buildPath + File.separator).length());
            }
        }
        if ((pieces = PApplet.match(s, ERROR_FORMAT)) != null) {
            RunnerException exception;
            error = pieces[pieces.length - 1];
            String msg = "";
            if (error.trim().equals("SPI.h: No such file or directory")) {
                error = I18n.tr("Please import the SPI library from the Sketch > Import Library menu.");
                msg = I18n.tr("\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.\n\n");
            }
            if (error.trim().equals("'BYTE' was not declared in this scope")) {
                error = I18n.tr("The 'BYTE' keyword is no longer supported.");
                msg = I18n.tr("\nAs of Arduino 1.0, the 'BYTE' keyword is no longer supported.\nPlease use Serial.write() instead.\n\n");
            }
            if (error.trim().equals("no matching function for call to 'Server::Server(int)'")) {
                error = I18n.tr("The Server class has been renamed EthernetServer.");
                msg = I18n.tr("\nAs of Arduino 1.0, the Server class in the Ethernet library has been renamed to EthernetServer.\n\n");
            }
            if (error.trim().equals("no matching function for call to 'Client::Client(byte [4], int)'")) {
                error = I18n.tr("The Client class has been renamed EthernetClient.");
                msg = I18n.tr("\nAs of Arduino 1.0, the Client class in the Ethernet library has been renamed to EthernetClient.\n\n");
            }
            if (error.trim().equals("'Udp' was not declared in this scope")) {
                error = I18n.tr("The Udp class has been renamed EthernetUdp.");
                msg = I18n.tr("\nAs of Arduino 1.0, the Udp class in the Ethernet library has been renamed to EthernetUdp.\n\n");
            }
            if (error.trim().equals("'class TwoWire' has no member named 'send'")) {
                error = I18n.tr("Wire.send() has been renamed Wire.write().");
                msg = I18n.tr("\nAs of Arduino 1.0, the Wire.send() function was renamed to Wire.write() for consistency with other libraries.\n\n");
            }
            if (error.trim().equals("'class TwoWire' has no member named 'receive'")) {
                error = I18n.tr("Wire.receive() has been renamed Wire.read().");
                msg = I18n.tr("\nAs of Arduino 1.0, the Wire.receive() function was renamed to Wire.read() for consistency with other libraries.\n\n");
            }
            if (error.trim().equals("'Mouse' was not declared in this scope")) {
                error = I18n.tr("'Mouse' not found. Does your sketch include the line '#include <Mouse.h>'?");
            }
            if (error.trim().equals("'Keyboard' was not declared in this scope")) {
                error = I18n.tr("'Keyboard' not found. Does your sketch include the line '#include <Keyboard.h>'?");
            }
            if ((exception = this.placeException(error, pieces[1], PApplet.parseInt(pieces[2]) - 1)) != null) {
                SketchCode code = this.sketch.getCode(exception.getCodeIndex());
                String fileName = code.isExtension("ino") || code.isExtension("pde") ? code.getPrettyName() : code.getFileName();
                int lineNum = exception.getCodeLine() + 1;
                s = fileName + ":" + lineNum + ": error: " + error + msg;
            }
            if (exception != null && (this.exception == null || this.exception.getMessage().equals(exception.getMessage()))) {
                this.exception = exception;
                this.exception.hideStackTrace();
            }
        }
        if (s.contains("undefined reference to `SPIClass::begin()'") && s.contains("libraries/Robot_Control")) {
            error = I18n.tr("Please import the SPI library from the Sketch > Import Library menu.");
            this.exception = new RunnerException(error);
        }
        if (s.contains("undefined reference to `Wire'") && s.contains("libraries/Robot_Control")) {
            error = I18n.tr("Please import the Wire library from the Sketch > Import Library menu.");
            this.exception = new RunnerException(error);
        }
        System.err.println(s);
    }

    private RunnerException placeException(String message, String fileName, int line) {
        for (SketchCode code : this.sketch.getCodes()) {
            if (!new File(fileName).getName().equals(code.getFileName())) continue;
            return new RunnerException(message, this.sketch.indexOfCode(code), line);
        }
        return null;
    }

    static {
        I18n.tr("'arch' folder is no longer supported! See http://goo.gl/gfFJzU for more information");
        I18n.tr("Board {0} (platform {1}, package {2}) is unknown");
        I18n.tr("Bootloader file specified but missing: {0}");
        I18n.tr("Build options changed, rebuilding all");
        I18n.tr("Unable to find {0} in {1}");
        I18n.tr("Invalid quoting: no closing [{0}] char found.");
        I18n.tr("(legacy)");
        I18n.tr("Multiple libraries were found for \"{0}\"");
        I18n.tr(" Not used: {0}");
        I18n.tr(" Used: {0}");
        I18n.tr("Library can't use both 'src' and 'utility' folders. Double check {0}");
        I18n.tr("WARNING: library {0} claims to run on {1} architecture(s) and may be incompatible with your current board which runs on {2} architecture(s).");
        I18n.tr("Looking for recipes like {0}*{1}");
        I18n.tr("Board {0}:{1}:{2} doesn''t define a ''build.board'' preference. Auto-set to: {3}");
        I18n.tr("Selected board depends on '{0}' core (not installed).");
        I18n.tr("{0} must be a folder");
        I18n.tr("{0}: Unknown package");
        I18n.tr("{0} pattern is missing");
        I18n.tr("Platform {0} (package {1}) is unknown");
        I18n.tr("Progress {0}");
        I18n.tr("Missing '{0}' from library in {1}");
        I18n.tr("Running: {0}");
        I18n.tr("Running recipe: {0}");
        I18n.tr("Setting build path to {0}");
        I18n.tr("Unhandled type {0} in context key {1}");
        I18n.tr("Unknown sketch file extension: {0}");
        I18n.tr("Using library {0} at version {1} in folder: {2} {3}");
        I18n.tr("Using library {0} in folder: {1} {2}");
        I18n.tr("Using previously compiled file: {0}");
        I18n.tr("WARNING: Category '{0}' in library {1} is not valid. Setting to '{2}'");
        I18n.tr("Warning: platform.txt from core '{0}' misses property '{1}', using default value '{2}'. Consider upgrading this core.");
        I18n.tr("Warning: platform.txt from core '{0}' contains deprecated {1}, automatically converted to {2}. Consider upgrading this core.");
        I18n.tr("WARNING: Spurious {0} folder in '{1}' library");
        ERROR_FORMAT = Pattern.compile("(.+\\.\\w+):(\\d+)(:\\d+)*:\\s*error:\\s*(.*)\\s*", 40);
    }

    static enum BuilderAction {
        COMPILE("-compile"),
        DUMP_PREFS("-dump-prefs");

        private final String value;

        private BuilderAction(String value) {
            this.value = value;
        }
    }
}

